/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.dex.base.IndirectIntegerPair;
import com.reandroid.dex.base.ParallelIntegerPair;
import com.reandroid.dex.base.ParallelReference;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.header.CountAndOffset;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.dex.sections.MapList;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;

public class MapItem
extends DexBlockItem
implements Comparable<MapItem> {
    private final IndirectInteger type = new IndirectInteger(this, 0);
    private final ParallelIntegerPair countAndOffset = new ParallelIntegerPair(new IndirectIntegerPair(this, 4));
    public static final int SIZE = 12;

    public MapItem() {
        super(12);
    }

    public void link(DexHeader header) {
        CountAndOffset headerCountAndOffset = header.get(this.getSectionType());
        if (headerCountAndOffset != null) {
            this.getCountAndOffset().add(headerCountAndOffset);
        }
    }

    public ParallelIntegerPair getCountAndOffset() {
        return this.countAndOffset;
    }

    public boolean isNormalItem() {
        SectionType sectionType = this.getSectionType();
        return sectionType != null && !sectionType.isSpecialSection();
    }

    public boolean hasNoSection() {
        return this.getSection(this.getSectionType()) == null;
    }

    public <T1 extends SectionItem> SectionType<T1> getSectionType() {
        return SectionType.get(this.getType().get());
    }

    public <T1 extends SectionItem> Section<T1> createNewSection() {
        SectionType<T1> sectionType = this.getSectionType();
        if (sectionType == null) {
            System.err.println("Unknown section: " + this.toString());
            return null;
        }
        Block parent = this.getParent(SectionList.class);
        if (parent != null) {
            parent = parent.getParent();
        }
        if (parent == null) {
            parent = this.getParent(MapList.class);
        }
        if (parent == null) {
            parent = this.getParent(DexLayoutBlock.class);
        }
        if (parent == null) {
            parent = this.getParent();
        }
        Section<T1> section = sectionType.createSection(this.getCountAndOffset());
        section.setParent(parent);
        return section;
    }

    public void setType(SectionType<?> type) {
        this.getType().set(type.getType());
    }

    public IntegerReference getType() {
        return this.type;
    }

    public ParallelReference getCount() {
        return this.countAndOffset.getFirst();
    }

    public int getCountValue() {
        return this.getCount().get();
    }

    public void setCount(int value) {
        this.getCount().set(value);
    }

    public ParallelReference getOffset() {
        return this.countAndOffset.getSecond();
    }

    public int getOffsetValue() {
        return this.getOffset().get();
    }

    public void setOffset(int value) {
        this.getOffset().set(value);
    }

    @Override
    public int compareTo(MapItem mapItem) {
        if (mapItem == this) {
            return 0;
        }
        return CompareUtil.compare(this.getOffsetValue(), mapItem.getOffsetValue());
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        SectionType sectionType = this.getSectionType();
        String name = sectionType == null ? HexUtil.toHex("UNKNOWN_", this.getType().get(), 1) : sectionType.getName();
        builder.append(name);
        builder.append(' ');
        int fill = 24 - name.length();
        for (int i2 = 0; i2 < fill; ++i2) {
            builder.append('-');
        }
        ParallelIntegerPair co = this.getCountAndOffset();
        builder.append("[");
        name = Integer.toString(co.getFirst().get());
        builder.append(name);
        fill = 6 - name.length();
        for (i = 0; i < fill; ++i) {
            builder.append(' ');
        }
        builder.append(',');
        name = Integer.toString(co.getSecond().get());
        fill = 8 - name.length();
        for (i = 0; i < fill; ++i) {
            builder.append(' ');
        }
        builder.append(name);
        builder.append(']');
        return builder.toString();
    }
}

