/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.ParallelIntegerPair;
import com.reandroid.dex.base.ParallelReference;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.sections.DexContainerBlock;
import com.reandroid.dex.sections.MapItem;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.SpecialItem;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.CollectionUtil;
import java.util.Iterator;
import java.util.List;

public class MapList
extends SpecialItem
implements Iterable<MapItem>,
PositionAlignedItem {
    private final CountedBlockList<MapItem> itemArray;
    private final DexPositionAlign positionAlign;
    private final ParallelReference fileSize;
    private final ParallelReference dataStart;
    private final ParallelReference dataSize;
    private static final Creator<MapItem> CREATOR = MapItem::new;

    public MapList(IntegerReference offsetReference) {
        super(3);
        IntegerItem mapItemsCount = new IntegerItem();
        this.itemArray = new CountedBlockList<MapItem>(CREATOR, mapItemsCount);
        this.positionAlign = new DexPositionAlign();
        this.addChildBlock(0, this.positionAlign);
        this.addChildBlock(1, mapItemsCount);
        this.addChildBlock(2, this.itemArray);
        this.setOffsetReference(offsetReference);
        this.fileSize = new ParallelReference(new FileSizeReference(this));
        this.dataStart = new ParallelReference(new DataStartReference(this));
        this.dataSize = new ParallelReference(new DataSizeReference(this));
    }

    public SectionType<MapList> getSectionType() {
        return SectionType.MAP_LIST;
    }

    public ParallelReference getFileSize() {
        return this.fileSize;
    }

    public ParallelReference getDataStart() {
        return this.dataStart;
    }

    public ParallelReference getDataSize() {
        return this.dataSize;
    }

    public void sort() {
        this.itemArray.sort(CompareUtil.getComparableComparator());
    }

    public void linkHeader(DexHeader dexHeader) {
        this.linkSpecialReference(SectionType.HEADER);
        this.linkSpecialReference(SectionType.MAP_LIST);
        this.linkIdTypesHeader(dexHeader);
        this.getFileSize().add(dexHeader.fileSize);
        this.getDataSize().add(dexHeader.data.getFirst());
        this.getDataStart().add(dexHeader.data.getSecond());
    }

    private void linkSpecialReference(SectionType<?> sectionType) {
        MapItem mapItem = this.get(sectionType);
        Section<?> section = this.getSection(sectionType);
        section.addCountAndOffset(mapItem.getCountAndOffset());
    }

    private void linkIdTypesHeader(DexHeader dexHeader) {
        Iterator<SectionType<?>> iterator = SectionType.getIdSectionTypes();
        while (iterator.hasNext()) {
            SectionType<?> sectionType = iterator.next();
            MapItem mapItem = this.get(sectionType);
            if (mapItem == null) continue;
            mapItem.link(dexHeader);
        }
    }

    public MapItem getDataStartItem() {
        boolean headerFound = false;
        for (MapItem mapItem : this) {
            SectionType sectionType = mapItem.getSectionType();
            if (!headerFound) {
                headerFound = sectionType == SectionType.HEADER;
                continue;
            }
            if (!sectionType.isDataSection()) continue;
            return mapItem;
        }
        return null;
    }

    boolean hasMultiLayoutVersion() {
        DexContainerBlock containerBlock = this.getParentInstance(DexContainerBlock.class);
        return containerBlock != null && containerBlock.hasMultiLayoutVersion();
    }

    public void remove(SectionType<?> sectionType) {
        this.remove(this.get(sectionType));
    }

    public void remove(MapItem mapItem) {
        if (mapItem == null) {
            return;
        }
        ParallelIntegerPair pair = mapItem.getCountAndOffset();
        pair.getFirst().set(0);
        pair.getSecond().set(0);
        this.itemArray.remove(mapItem);
        mapItem.setParent(null);
        mapItem.setIndex(-1);
    }

    public MapItem get(SectionType<?> type) {
        for (MapItem mapItem : this) {
            if (type != mapItem.getSectionType()) continue;
            return mapItem;
        }
        return null;
    }

    public MapItem getOrCreate(SectionType<?> type) {
        MapItem mapItem = this.get(type);
        if (mapItem != null) {
            return mapItem;
        }
        mapItem = (MapItem)this.itemArray.createNext();
        mapItem.setType(type);
        return mapItem;
    }

    @Override
    public Iterator<MapItem> iterator() {
        return this.itemArray.iterator();
    }

    MapItem[] getBodyReaderSorted() {
        List<MapItem> list = CollectionUtil.toList(this.itemArray.iterator(MapItem::isNormalItem));
        list.sort(SectionType.getReadComparator(MapItem::getSectionType));
        return list.toArray(new MapItem[list.size()]);
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.itemArray.removeIf(MapItem::hasNoSection);
        this.sort();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.getFileSize().refresh();
        this.getDataStart().refresh();
        this.getDataSize().refresh();
    }

    public String toString() {
        Iterator it = this.itemArray.iterator();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (it.hasNext()) {
            MapItem item = (MapItem)it.next();
            if (i != 0) {
                builder.append('\n');
            }
            if (i < 9) {
                builder.append(' ');
            }
            builder.append(i + 1);
            builder.append(") ");
            builder.append(item);
            ++i;
        }
        return builder.toString();
    }

    @Override
    public DexPositionAlign getPositionAlign() {
        return this.positionAlign;
    }

    static class FileSizeReference
    implements IntegerReference {
        private final MapList mapList;

        private FileSizeReference(MapList mapList) {
            this.mapList = mapList;
        }

        @Override
        public int get() {
            return this.mapList.getOffset() + this.mapList.countBytes() - this.getHeaderBaseOffset();
        }

        @Override
        public void set(int value) {
        }

        private int getHeaderBaseOffset() {
            SectionList sectionList = this.mapList.getSectionList();
            if (sectionList != null) {
                return sectionList.getHeader().getOffsetReference().get();
            }
            return 0;
        }
    }

    static class DataSizeReference
    implements IntegerReference {
        private final MapList mapList;

        private DataSizeReference(MapList mapList) {
            this.mapList = mapList;
        }

        @Override
        public int get() {
            MapList mapList = this.mapList;
            if (mapList.hasMultiLayoutVersion()) {
                return 0;
            }
            MapItem mapItem = mapList.getDataStartItem();
            if (mapItem != null) {
                return mapList.getFileSize().get() - mapItem.getOffset().get();
            }
            return 0;
        }

        @Override
        public void set(int value) {
        }

        public String toString() {
            return Integer.toString(this.get());
        }
    }

    static class DataStartReference
    implements IntegerReference {
        private final MapList mapList;

        private DataStartReference(MapList mapList) {
            this.mapList = mapList;
        }

        @Override
        public int get() {
            MapList mapList = this.mapList;
            if (mapList.hasMultiLayoutVersion()) {
                return 0;
            }
            MapItem mapItem = mapList.getDataStartItem();
            if (mapItem != null) {
                return mapItem.getOffset().get();
            }
            return 0;
        }

        @Override
        public void set(int value) {
        }

        public String toString() {
            return Integer.toString(this.get());
        }
    }
}

