/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.DexContainerBlock;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;

public interface MergeOptions {
    public static final MergeOptions DEFAULT = new MergeOptions(){

        @Override
        public boolean skipMerging(ClassId classId, TypeKey typeKey) {
            return false;
        }

        @Override
        public void onDuplicate(ClassId classId) {
            classId.removeSelf();
        }

        @Override
        public void onMergeError(DexLayoutBlock dexLayoutBlock, ClassId classId, String message) {
        }

        @Override
        public void onMergeError(DexLayoutBlock dexLayoutBlock, SectionList sectionList, String message) {
        }

        @Override
        public void onDexFull(DexLayoutBlock dexLayoutBlock, ClassId classId) {
        }

        @Override
        public void onMergeSuccess(ClassId classId, TypeKey key) {
        }

        @Override
        public boolean relocateClass() {
            return true;
        }

        @Override
        public DexLayoutBlock onCreateNext(DexLayoutBlock last) {
            return null;
        }
    };

    public boolean skipMerging(ClassId var1, TypeKey var2);

    public void onDuplicate(ClassId var1);

    public void onMergeError(DexLayoutBlock var1, ClassId var2, String var3);

    public void onMergeError(DexLayoutBlock var1, SectionList var2, String var3);

    public void onDexFull(DexLayoutBlock var1, ClassId var2);

    public void onMergeSuccess(ClassId var1, TypeKey var2);

    public boolean relocateClass();

    default public int getMergeStartDexFile() {
        return 0;
    }

    default public void setMergeStartDexFile(int startDexFile) {
    }

    public DexLayoutBlock onCreateNext(DexLayoutBlock var1);

    default public boolean isEmptyDexFile(DexLayoutBlock dexLayoutBlock) {
        if (dexLayoutBlock == null || dexLayoutBlock.isEmpty()) {
            return true;
        }
        Section<ClassId> section = dexLayoutBlock.getSection(SectionType.CLASS_ID);
        for (ClassId classId : section) {
            if (this.skipMerging(classId, classId.getKey())) continue;
            return false;
        }
        return true;
    }

    default public boolean isEmptyDexFile(DexContainerBlock dexContainerBlock) {
        if (dexContainerBlock == null || dexContainerBlock.isEmpty()) {
            return true;
        }
        for (DexLayoutBlock layoutBlock : dexContainerBlock) {
            if (this.isEmptyDexFile(layoutBlock)) continue;
            return false;
        }
        return true;
    }
}

