/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.dex.base.DexArraySupplier;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.FixedDexContainer;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class Section<T extends SectionItem>
extends FixedDexContainer
implements DexArraySupplier<T>,
OffsetSupplier,
Iterable<T>,
FullRefresh {
    private final SectionType<T> sectionType;
    private final DexPositionAlign sectionAlign;
    private final SectionArray<T> itemArray;
    private DexSectionPool<T> dexSectionPool;

    Section(SectionType<T> sectionType, SectionArray<T> itemArray) {
        super(2);
        this.sectionType = sectionType;
        this.itemArray = itemArray;
        this.sectionAlign = Section.fixedAligner(sectionType.sectionAlignment());
        this.addChild(0, this.sectionAlign);
        this.addChild(1, itemArray);
    }

    public Section(IntegerPair countAndOffset, SectionType<T> sectionType) {
        this(sectionType, new SectionArray<T>(countAndOffset, sectionType.getCreator()));
    }

    @Override
    public void refreshFull() {
        this.clearPoolMap();
        SectionArray<T> array = this.getItemArray();
        array.refreshFull();
        this.sort();
        this.refresh();
    }

    int clearUnused() {
        int size = this.getCount();
        this.removeEntries(item -> item.getUsageType() == UsageMarker.USAGE_NONE);
        return size - this.getCount();
    }

    public int clearDuplicates() {
        int i = this.getPool().clearDuplicates();
        if (i != 0) {
            this.refresh();
        }
        return i;
    }

    public boolean remove(Key key) {
        return false;
    }

    public boolean removeWithKeys(Predicate<? super Key> filter) {
        return false;
    }

    public boolean removeEntries(Predicate<? super T> filter) {
        return this.getItemArray().removeIf(filter);
    }

    void clearUsageTypes() {
        UsageMarker.clearUsageTypes(this.iterator());
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public void removeSelf() {
        SectionList sectionList = this.getSectionList();
        if (sectionList != null) {
            sectionList.remove(this);
        }
    }

    void onRemove(SectionList sectionList) {
        this.clear();
        sectionList.getMapList().remove(this.getSectionType());
        this.setParent(null);
        this.setIndex(-1);
    }

    public void clear() {
        this.clearPoolMap();
        this.getItemArray().clear();
    }

    public void clearPoolMap() {
        DexSectionPool<T> dexSectionPool = this.getLoadedPool();
        if (dexSectionPool != null) {
            dexSectionPool.clear();
            this.dexSectionPool = null;
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.sectionAlign.setAlignment(0);
        super.onReadBytes(reader);
    }

    public boolean contains(Key key) {
        return this.getPool().contains(key);
    }

    public Iterator<T> getAll(Key key) {
        return this.getPool().getAll(key);
    }

    public T getSectionItem(Key key) {
        return (T)((SectionItem)this.getPool().get(key));
    }

    boolean keyChanged(SectionItem block, Key key) {
        DexSectionPool<T> dexSectionPool = this.getLoadedPool();
        if (dexSectionPool != null) {
            return dexSectionPool.updateKey(key, block.getKey(), ObjectsUtil.cast(block));
        }
        return false;
    }

    public DexSectionPool<T> getPool() {
        DexSectionPool<T> dexSectionPool = this.dexSectionPool;
        if (dexSectionPool == null) {
            dexSectionPool = this.createPool();
            this.dexSectionPool = dexSectionPool;
            dexSectionPool.load();
        }
        return dexSectionPool;
    }

    public DexSectionPool<T> getLoadedPool() {
        return this.dexSectionPool;
    }

    DexSectionPool<T> createPool() {
        return new DexSectionPool(this);
    }

    public void add(T item) {
        this.getItemArray().add(item);
    }

    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    public T getSectionItem(int idx) {
        return null;
    }

    public T getOrCreate(Key key) {
        return this.getPool().getOrCreate(key);
    }

    public T createItem() {
        return (T)((SectionItem)this.getItemArray().createNext());
    }

    public T get(Key key) {
        return (T)((SectionItem)this.getPool().get(key));
    }

    @Override
    public T get(int i) {
        return (T)((SectionItem)this.getItemArray().get(i));
    }

    @Override
    public int getCount() {
        return this.getItemArray().getCount();
    }

    public int getOffset() {
        return this.getOffsetReference().get();
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.getItemArray().getOffsetReference();
    }

    public IntegerPair getCountAndOffset() {
        return this.getItemArray().getCountAndOffset();
    }

    public void addCountAndOffset(IntegerPair countAndOffset) {
        this.getItemArray().addCountAndOffset(countAndOffset);
    }

    public SectionArray<T> getItemArray() {
        return this.itemArray;
    }

    public boolean sort() throws ClassCastException {
        Object first = this.getItemArray().getFirst();
        if (!(first instanceof Comparable)) {
            return false;
        }
        return this.sort(CompareUtil.getComparatorUnchecked());
    }

    public boolean sort(Comparator<? super T> comparator) {
        return this.getItemArray().sort(comparator);
    }

    public Iterator<T> clonedIterator() {
        return this.getItemArray().clonedIterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getItemArray().iterator();
    }

    public Iterator<T> iterator(Predicate<? super T> filter) {
        return this.getItemArray().iterator(filter);
    }

    public Iterator<T> arrayIterator() {
        return this.getItemArray().arrayIterator();
    }

    void updateNextSection(int position) {
        Section<?> next = this.getNextSection();
        if (next != null) {
            next.getOffsetReference().set(position);
        }
    }

    Section<?> getNextSection() {
        int i;
        SectionList sectionList = this.getSectionList();
        if (sectionList != null && (i = sectionList.indexOf(this)) >= 0) {
            return sectionList.get(i + 1);
        }
        return null;
    }

    Section<?> getPreviousSection() {
        int i;
        SectionList sectionList = this.getSectionList();
        if (sectionList != null && (i = sectionList.indexOf(this)) >= 0) {
            return sectionList.get(i - 1);
        }
        return null;
    }

    public SectionList getSectionList() {
        return this.getParent(SectionList.class);
    }

    int compareOffset(Section<?> section) {
        if (section == null) {
            return 1;
        }
        return CompareUtil.compare(this.getOffset(), section.getOffset());
    }

    @Override
    protected boolean isValidOffset(int offset) {
        if (offset == 0) {
            return this.getSectionType() == SectionType.HEADER;
        }
        return offset > 0;
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.removeEntries(SectionItem::isBlank);
    }

    @Override
    protected void onRefreshed() {
        int position = this.getOffset();
        position += this.sectionAlign.align(position);
        this.getOffsetReference().set(position);
        this.onRefreshed(position);
        this.clearPoolMap();
    }

    void onRefreshed(int position) {
        this.updateNextSection(position += this.getItemArray().countBytes());
    }

    void onRemoving(T item) {
        DexSectionPool<T> dexSectionPool = this.dexSectionPool;
        if (dexSectionPool != null) {
            dexSectionPool.remove(item);
        }
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream();
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public String toString() {
        return this.getSectionType() + ", offset = " + this.getOffset() + ", count = " + this.getCount();
    }

    private static DexPositionAlign fixedAligner(final int sectionAlignment) {
        return new DexPositionAlign(sectionAlignment){

            @Override
            public void setAlignment(int alignment) {
                super.setAlignment(sectionAlignment);
            }

            @Override
            public void setSize(int size) {
                if (sectionAlignment == 0) {
                    size = 0;
                }
                super.setSize(size);
            }
        };
    }
}

