/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.header.DexHeader;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.DexContainerBlock;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.dex.sections.IdSection;
import com.reandroid.dex.sections.MapItem;
import com.reandroid.dex.sections.MapList;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionArray;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.sections.SpecialItem;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ArraySupplierIterator;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class SectionList
extends FixedBlockContainer
implements SectionTool,
OffsetSupplier,
Iterable<Section<?>>,
ArraySupplier<Section<?>>,
FullRefresh {
    private final IntegerReference baseOffset;
    private final DexHeader dexHeader;
    private final BlockList<Section<?>> sectionArray;
    private final Map<SectionType<?>, Section<?>> typeMap;
    private final MapList mapList;

    public SectionList() {
        super(1);
        BlockList<Section<SpecialItem>> sectionArray = new BlockList<Section<SpecialItem>>();
        this.sectionArray = sectionArray;
        DexHeader dexHeader = new DexHeader();
        this.baseOffset = dexHeader.getOffsetReference();
        Section<DexHeader> dexHeaderSection = SectionType.HEADER.createSpecialSection(this.baseOffset);
        dexHeaderSection.add(dexHeader);
        Section<MapList> mapListSection = SectionType.MAP_LIST.createSpecialSection(dexHeader.map);
        MapList mapList = new MapList(dexHeader.map);
        mapListSection.add(mapList);
        sectionArray.add(dexHeaderSection);
        sectionArray.add(mapListSection);
        this.typeMap = new HashMap();
        this.addChild(0, sectionArray);
        this.dexHeader = dexHeader;
        this.mapList = mapList;
        this.typeMap.put(SectionType.HEADER, dexHeaderSection);
        this.typeMap.put(SectionType.MAP_LIST, mapListSection);
    }

    public int shrink() {
        int count;
        int result = 0;
        while ((count = this.clearDuplicateData()) != 0) {
            result += count;
        }
        return result += this.clearEmptySections();
    }

    public int clearDuplicateData() {
        SectionType<?>[] remove;
        this.refresh();
        int result = 0;
        for (SectionType<?> sectionType : remove = SectionType.getRemoveOrderList()) {
            Section<?> section = this.getSection(sectionType);
            if (section == null) continue;
            result += section.clearDuplicates();
        }
        if (result != 0) {
            this.refresh();
        }
        return result;
    }

    public int clearUnused() {
        SectionType<?>[] remove;
        int result = 0;
        for (SectionType<?> sectionType : remove = SectionType.getRemoveOrderList()) {
            Section<?> section = this.getSection(sectionType);
            if (section == null) continue;
            result += section.clearUnused();
        }
        return result;
    }

    public int clearEmptySections() {
        int result = 0;
        List<Section<?>> sections = CollectionUtil.toList(this.getSections());
        for (Section<?> section : sections) {
            if (!section.isEmpty()) continue;
            this.remove(section);
            ++result;
        }
        return result;
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.mapList.refresh();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.readSections(reader, null);
    }

    void readSections(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        int position = reader.getPosition();
        DexHeader header = this.getHeader();
        header.getOffsetReference().set(position);
        this.readSpecialSections(reader);
        this.readBody(reader, filter);
        reader.seek(position + header.getFileSize());
    }

    private void readSpecialSections(BlockReader reader) throws IOException {
        this.getSection(SectionType.HEADER).readBytes(reader);
        this.getSection(SectionType.MAP_LIST).readBytes(reader);
        this.ensureMapList(this.getSection(SectionType.HEADER));
        this.ensureMapList(this.getSection(SectionType.MAP_LIST));
    }

    private void readBody(BlockReader reader, Predicate<SectionType<?>> filter) throws IOException {
        for (MapItem mapItem : this.mapList.getBodyReaderSorted()) {
            SectionType sectionType = mapItem.getSectionType();
            if (filter != null && !filter.test(sectionType)) continue;
            this.loadSection(mapItem, reader);
        }
        this.sectionArray.sort(SectionList.getOffsetComparator());
        this.mapList.linkHeader(this.dexHeader);
    }

    private void loadSection(MapItem mapItem, BlockReader reader) throws IOException {
        Section section = this.getSection(mapItem.getSectionType());
        if (section == null) {
            section = mapItem.createNewSection();
            this.add(section);
        }
        if (this.ownsSection(section)) {
            section.readBytes(reader);
        } else {
            this.ensureMapList(section);
        }
    }

    @Override
    public boolean isReading() {
        DexContainerBlock containerBlock = this.getDexContainerBlock();
        if (containerBlock != null) {
            return containerBlock.isReading();
        }
        return true;
    }

    public DexContainerBlock getDexContainerBlock() {
        DexLayoutBlock layoutBlock = this.getLayoutBlock();
        if (layoutBlock != null) {
            return layoutBlock.getDexContainerBlock();
        }
        return (DexContainerBlock)ObjectsUtil.getNull();
    }

    public DexLayoutBlock getLayoutBlock() {
        return this.getParentInstance(DexLayoutBlock.class);
    }

    public <T1 extends SectionItem> Section<T1> add(Section<T1> section) {
        int index;
        SectionType<T1> sectionType = section.getSectionType();
        Section<T1> existing = this.getSection(sectionType);
        if (existing == section) {
            return existing;
        }
        if (existing != null) {
            throw new IllegalArgumentException("Already contains section type: " + sectionType + ", existing = " + existing + ", section = " + section);
        }
        BlockList<Section<?>> sectionArray = this.sectionArray;
        int size = sectionArray.size();
        if (sectionType == SectionType.HEADER) {
            index = 0;
        } else if (sectionType == SectionType.MAP_LIST) {
            index = sectionArray.size();
        } else if (section.getOffset() == 0) {
            index = 1;
            for (int i = 1; i < size; ++i) {
                SectionType<?> current = sectionArray.get(i).getSectionType();
                if ((!sectionType.isIdSection() || !current.isIdSection()) && (!sectionType.isDataSection() || !current.isDataSection())) continue;
                ++index;
            }
        } else {
            index = 1;
            int offset = section.getOffset();
            for (int i = 1; i < size; ++i) {
                int current = sectionArray.get(i).getOffset();
                if (offset <= current) continue;
                ++index;
            }
        }
        sectionArray.add(index, section);
        this.typeMap.put(section.getSectionType(), section);
        return section;
    }

    public DexHeader getHeader() {
        return this.dexHeader;
    }

    public MapList getMapList() {
        return this.mapList;
    }

    public void remove(Section<?> section) {
        if (section == null) {
            return;
        }
        SectionType<?> sectionType = section.getSectionType();
        if (this.typeMap.remove(sectionType) != section) {
            return;
        }
        section.onRemove(this);
        this.sectionArray.remove(section);
    }

    private Section<?> cut(Section<?> section) {
        if (this.sectionArray.remove(section)) {
            this.typeMap.remove(section.getSectionType());
            return section;
        }
        return null;
    }

    public void clear() {
        Iterator<Section<?>> iterator = this.getSections();
        while (iterator.hasNext()) {
            Section<?> section = iterator.next();
            section.onRemove(this);
        }
        this.sectionArray.clearChildes();
        this.typeMap.clear();
    }

    public void clearPoolMap(SectionType<?> sectionType) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            section.clearPoolMap();
        }
    }

    public void clearPoolMap() {
        for (Section<?> section : this) {
            section.clearPoolMap();
        }
    }

    public void sortSection(SectionType<?>[] order) {
        this.sectionArray.sort(SectionType.comparator(order, Section::getSectionType));
        this.mapList.sort();
    }

    @Override
    public void refreshFull() {
        SectionType<?>[] sortOrder;
        for (SectionType<?> sectionType : sortOrder = SectionType.getSortSectionsOrder()) {
            Section<?> section = this.getSection(sectionType);
            if (section == null) continue;
            section.refreshFull();
        }
        this.clearDuplicateData();
        if (this.clearEmptySections() != 0) {
            this.refresh();
        }
    }

    public boolean sortStrings() {
        boolean result = this.sortItems(SectionType.STRING_DATA);
        if (this.sortItems(SectionType.STRING_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.TYPE_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.PROTO_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.FIELD_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.METHOD_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.CLASS_ID)) {
            result = true;
        }
        if (this.sortItems(SectionType.ANNOTATION_SET)) {
            result = true;
        }
        return result;
    }

    private boolean sortItems(SectionType<?> sectionType) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            return section.sort();
        }
        return false;
    }

    public <T1 extends SectionItem> T1 getLoaded(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.getSectionItem(key);
        }
        return null;
    }

    @Override
    public <T1 extends SectionItem> Section<T1> getSection(SectionType<T1> sectionType) {
        if (sectionType != null) {
            Section<T1> section = this.getOwnedSection(sectionType);
            if (section == null && sectionType.isSharedSection()) {
                section = this.getForeignSection(sectionType);
            }
            return section;
        }
        return null;
    }

    private <T1 extends SectionItem> Section<T1> getForeignSection(SectionType<T1> sectionType) {
        DexContainerBlock containerBlock = this.getDexContainerBlock();
        if (containerBlock != null) {
            Iterator<SectionList> iterator = containerBlock.getSectionLists();
            while (iterator.hasNext()) {
                Section<T1> section;
                SectionList sectionList = iterator.next();
                if (sectionList == this || (section = sectionList.getOwnedSection(sectionType)) == null) continue;
                return section;
            }
        }
        return null;
    }

    <T1 extends SectionItem> Section<T1> getOwnedSection(SectionType<T1> sectionType) {
        return (Section)ObjectsUtil.cast(this.typeMap.get(sectionType));
    }

    private boolean ownsSection(Section<?> section) {
        return section != null && section.getParent(this.getClass()) == this;
    }

    @Override
    public SectionList getSectionList() {
        return this;
    }

    @Override
    public <T1 extends SectionItem> Section<T1> getOrCreateSection(SectionType<T1> sectionType) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section;
        }
        if (sectionType == SectionType.MAP_LIST || sectionType == SectionType.HEADER) {
            return null;
        }
        MapList mapList = this.getMapList();
        MapItem mapItem = mapList.getOrCreate(sectionType);
        section = mapItem.createNewSection();
        this.add(section);
        if (!this.isReading()) {
            this.sortSection(SectionType.getR8Order());
            mapItem.link(this.getHeader());
        }
        return section;
    }

    void ensureInitialized(SectionType<?> ... sectionTypes) {
        if (this.isReading() || sectionTypes == null || sectionTypes.length == 0) {
            return;
        }
        for (SectionType<?> type : sectionTypes) {
            if (type == null) continue;
            this.ensureMapList(this.getOrCreateSection(type));
        }
        this.getMapList().linkHeader(this.getHeader());
    }

    private void ensureMapList(Section<?> section) {
        SectionType<?> sectionType = section.getSectionType();
        MapList mapList = this.getMapList();
        MapItem mapItem = this.isReading() ? mapList.get(sectionType) : mapList.getOrCreate(sectionType);
        section.addCountAndOffset(mapItem.getCountAndOffset());
    }

    public int indexOf(Section<?> section) {
        return this.sectionArray.indexOf(section);
    }

    @Override
    public Section<?> get(int i) {
        return this.sectionArray.get(i);
    }

    public boolean contains(Key key) {
        if (key == null) {
            return false;
        }
        SectionType<?> sectionType = SectionType.getSectionType(key);
        if (sectionType != null) {
            return this.contains(sectionType, key);
        }
        throw new IllegalArgumentException("Unknown key type: " + key.getClass() + ", '" + key + "'");
    }

    private boolean contains(SectionType<?> sectionType, Key key) {
        Section<?> section = this.getSection(sectionType);
        if (section != null) {
            return section.contains(key);
        }
        return false;
    }

    public void keyChangedInternal(SectionItem item, SectionType<?> sectionType, Key oldKey) {
        ClassId classId;
        Section<?> section = this.getSection(sectionType);
        if (section == null) {
            return;
        }
        section.keyChanged(item, oldKey);
        if (sectionType == SectionType.TYPE_ID && (classId = this.getLoaded(SectionType.CLASS_ID, oldKey)) != null) {
            classId.getKey();
        }
    }

    public Iterator<Section<?>> getSections() {
        return this.sectionArray.arrayIterator();
    }

    public Iterator<IdSection<?>> getIdSections() {
        return (Iterator)ObjectsUtil.cast(this.sectionArray.iterator(IdSection.class));
    }

    @Override
    public int getCount() {
        return this.sectionArray.size();
    }

    public Iterator<Section<?>> getSharedSections() {
        return CollectionUtil.copyOf(this.sectionArray.iterator(section -> section.getSectionType().isSharedSection()));
    }

    @Override
    public Iterator<Section<?>> iterator() {
        return ArraySupplierIterator.of(this);
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.baseOffset;
    }

    void transferSharedSectionsFrom(SectionList sectionList) {
        if (sectionList != this) {
            Iterator<Section<?>> iterator = sectionList.getSharedSections();
            while (iterator.hasNext()) {
                this.transferSharedSection(sectionList, iterator.next());
            }
        }
    }

    private void transferSharedSection(SectionList sectionList, Section<?> section) {
        if ((section = sectionList.cut(section)) != null) {
            this.add(section);
            section.addCountAndOffset(this.mapList.get(section.getSectionType()).getCountAndOffset());
        }
    }

    private boolean canAddAll(Collection<IdItem> idItemCollection) {
        int reserveSpace = 200;
        Iterator<IdSection<?>> idSections = this.getIdSections();
        while (idSections.hasNext()) {
            IdSection<?> section = idSections.next();
            if (section.canAddAll(idItemCollection, reserveSpace)) continue;
            return false;
        }
        return true;
    }

    public boolean merge(MergeOptions options, ClassId classId) {
        if (classId == null) {
            options.onMergeError(this.getParentInstance(DexLayoutBlock.class), classId, "Null class id");
            return false;
        }
        if (classId.getParent() == null) {
            options.onMergeError(this.getParentInstance(DexLayoutBlock.class), classId, "Destroyed class id");
            return false;
        }
        if (classId.getParent(SectionList.class) == this) {
            options.onMergeError(this.getParentInstance(DexLayoutBlock.class), classId, "Class id is on same section");
            return false;
        }
        if (options.skipMerging(classId, classId.getKey())) {
            return false;
        }
        if (this.contains(SectionType.CLASS_ID, classId.getKey())) {
            options.onDuplicate(classId);
            return false;
        }
        ArrayCollection<IdItem> collection = classId.listUsedIds();
        if (!this.canAddAll(collection)) {
            options.onDexFull(this.getParentInstance(DexLayoutBlock.class), classId);
            return false;
        }
        Section<ClassId> mySection = this.getOrCreateSection(SectionType.CLASS_ID);
        ClassId myClass = mySection.getOrCreate(classId.getKey());
        myClass.merge(classId);
        if (options.relocateClass()) {
            classId.removeSelf();
        }
        options.onMergeSuccess(classId, classId.getKey());
        return true;
    }

    public boolean merge(MergeOptions options, SectionList sectionList) {
        int size;
        if (sectionList == this) {
            options.onMergeError(this.getParentInstance(DexLayoutBlock.class), sectionList, "Can not merge with self");
            return false;
        }
        if (sectionList.getParent() == null) {
            options.onMergeError(this.getParentInstance(DexLayoutBlock.class), sectionList, "Destroyed section list");
            return false;
        }
        Section<ClassId> comingSection = sectionList.getSection(SectionType.CLASS_ID);
        if (comingSection == null || comingSection.getCount() == 0) {
            return false;
        }
        boolean mergedOnce = false;
        boolean mergedAll = true;
        Section<ClassId> mySection = this.getOrCreateSection(SectionType.CLASS_ID);
        SectionArray<ClassId> comingArray = comingSection.getItemArray();
        for (int i = size = comingArray.size() - 1; i >= 0; --i) {
            TypeKey key;
            ClassId coming = (ClassId)comingArray.get(i);
            if (options.skipMerging(coming, key = coming.getKey())) continue;
            if (mySection.contains(key)) {
                options.onDuplicate(coming);
                continue;
            }
            ArrayCollection<IdItem> collection = coming.listUsedIds();
            if (!this.canAddAll(collection)) {
                mergedAll = false;
                options.onDexFull(this.getParentInstance(DexLayoutBlock.class), coming);
                break;
            }
            ClassId classId = mySection.getOrCreate(coming.getKey());
            classId.merge(coming);
            options.onMergeSuccess(coming, key);
            if (options.relocateClass()) {
                coming.removeSelf();
            }
            mergedOnce = true;
        }
        if (comingSection.getCount() == 0) {
            SectionList comingSectionSectionList = comingSection.getSectionList();
            DexLayoutBlock dexLayoutBlock = comingSectionSectionList.getParentInstance(DexLayoutBlock.class);
            dexLayoutBlock.clear();
        }
        if (mergedOnce) {
            this.sortStrings();
            this.refresh();
        }
        return mergedAll;
    }

    public ClassId fromSmali(SmaliClass smaliClass) throws IOException {
        ClassId classId = this.getOrCreateSectionItem(SectionType.CLASS_ID, smaliClass.getKey());
        classId.fromSmali(smaliClass);
        return classId;
    }

    private static <T1 extends Section<?>> Comparator<T1> getOffsetComparator() {
        return (section1, section2) -> {
            if (section1 == section2) {
                return 0;
            }
            if (section1 == null) {
                return 1;
            }
            return section1.compareOffset((Section<?>)section2);
        };
    }
}

