/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliFileNameFactory;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriterSetting;
import com.reandroid.dex.smali.formatters.SequentialLabelFactory;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.StringsUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;

public class SmaliWriter
implements Appendable,
Closeable {
    private Writer writer;
    private int indent;
    private int lineNumber = 1;
    private int columnNumber;
    private boolean state_new_line = true;
    private boolean indentRequested;
    private StringBuilder comment;
    private RegistersTable currentRegistersTable;
    private boolean stateWritingFields;
    private boolean stateWritingInstructions;
    private SmaliWriterSetting writerSetting;
    private SequentialLabelFactory sequentialLabelFactory;
    private static final int INDENT_STEP = 4;

    public SmaliWriter(Writer writer) {
        this();
        this.writer = writer;
    }

    public SmaliWriter() {
    }

    public void onWriteClass(TypeKey typeKey) throws IOException {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null && setting.isEnableComments()) {
            setting.writeClassComment(this, typeKey);
        }
    }

    public void onWriteMethod(MethodKey methodKey) throws IOException {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null && setting.isEnableComments()) {
            setting.writeMethodComment(this, methodKey);
        }
    }

    public void setWriter(Writer writer) {
        this.reset();
        this.writer = writer;
    }

    @Override
    public SmaliWriter append(CharSequence charSequence) throws IOException {
        this.write(charSequence, 0, charSequence.length());
        return this;
    }

    @Override
    public SmaliWriter append(CharSequence charSequence, int start, int length) throws IOException {
        this.write(charSequence, start, length);
        return this;
    }

    @Override
    public SmaliWriter append(char ch) throws IOException {
        this.write(ch);
        return this;
    }

    public void appendRegister(int registerValue) throws IOException {
        RegistersTable registersTable = this.getCurrentRegistersTable();
        if (registersTable == null) {
            throw new IOException("Current registers table not set");
        }
        Register register = registersTable.getRegisterFor(registerValue);
        register.append(this);
    }

    public void appendAllWithDoubleNewLine(Iterator<? extends SmaliFormat> iterator) throws IOException {
        while (iterator.hasNext()) {
            if (!this.state_new_line) {
                this.newLine();
            }
            if (this.indent == 0) {
                this.newLine();
            }
            iterator.next().append(this);
        }
    }

    public void appendAllWithIndent(Iterator<? extends SmaliFormat> iterator) throws IOException {
        boolean appendOnce = false;
        while (iterator.hasNext()) {
            if (!appendOnce) {
                this.indentPlus();
            }
            this.newLine();
            iterator.next().append(this);
            appendOnce = true;
        }
        if (appendOnce) {
            this.indentMinus();
        }
    }

    public void appendAll(Iterator<? extends SmaliFormat> iterator) throws IOException {
        this.appendAll(iterator, true);
    }

    public void appendAll(Iterator<? extends SmaliFormat> iterator, boolean newLine) throws IOException {
        boolean appendOnce = false;
        while (iterator.hasNext()) {
            if (newLine && appendOnce) {
                this.newLine();
            }
            iterator.next().append(this);
            appendOnce = true;
        }
    }

    public void appendModifiers(Iterator<? extends Modifier> iterator) throws IOException {
        while (iterator.hasNext()) {
            iterator.next().append(this);
        }
    }

    public boolean appendOptional(SmaliFormat smaliFormat) throws IOException {
        if (smaliFormat != null) {
            smaliFormat.append(this);
            return true;
        }
        return false;
    }

    public boolean appendOptional(SmaliFormat smaliFormat, String comment) throws IOException {
        if (smaliFormat == null) {
            return false;
        }
        this.newLine();
        this.appendCommentNewLine(comment);
        smaliFormat.append(this);
        return true;
    }

    public void appendRequired(SmaliFormat smaliFormat) throws IOException {
        if (smaliFormat == null) {
            throw new IOException("Null SmaliFormat");
        }
        smaliFormat.append(this);
    }

    public void append(double d) throws IOException {
        this.append(Double.toString(d));
    }

    public void append(float f) throws IOException {
        this.append(Float.toString(f));
        this.append('f');
    }

    public void appendInteger(int i) throws IOException {
        this.append(Integer.toString(i));
    }

    public void appendHex(byte b) throws IOException {
        this.append(HexUtil.toSignedHex(b));
        this.append('t');
    }

    public void appendHex(short s) throws IOException {
        this.append(HexUtil.toSignedHex(s));
        this.append('S');
    }

    public void appendHex(int i) throws IOException {
        this.append(HexUtil.toSignedHex(i));
        this.appendResourceIdComment(i);
    }

    public void appendHex(long l) throws IOException {
        this.append(HexUtil.toSignedHex(l));
        this.append('L');
        this.appendResourceIdComment(l);
    }

    public void appendHex(int width, long l) throws IOException {
        String hex = HexUtil.toSignedHex(l);
        this.append(hex);
        if (width == 1) {
            this.append('t');
        } else if (width == 2) {
            this.append('S');
        } else if (width == 8 && (l & Integer.MIN_VALUE) != 0L) {
            this.append('L');
        }
        this.appendResourceIdComment(l);
    }

    public void appendResourceIdComment(long l) throws IOException {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null) {
            setting.writeResourceIdComment(this, l);
        }
    }

    public void appendResourceIdComment(int i) throws IOException {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null) {
            setting.writeResourceIdComment(this, i);
        }
    }

    public void appendLabelName(String name) throws IOException {
        SequentialLabelFactory labelFactory = this.getSequentialLabelFactory();
        if (labelFactory != null) {
            name = labelFactory.get(name);
        }
        this.append(name);
    }

    public void newLineDouble() throws IOException {
        this.newLine(2);
    }

    public void newLine() throws IOException {
        this.newLine(1);
    }

    public void newLine(int amount) throws IOException {
        if (this.lineNumber == 1 && this.columnNumber == 0 || amount == 0) {
            return;
        }
        this.flushComment();
        for (int i = 0; i < amount; ++i) {
            this.writer.append('\n');
        }
        this.columnNumber = 0;
        this.lineNumber += amount;
        this.state_new_line = true;
        this.indentRequested = true;
    }

    private void flushIndent() throws IOException {
        if (this.indentRequested) {
            this.writeIndent();
        }
    }

    private void writeIndent() throws IOException {
        this.indentRequested = false;
        Writer writer = this.writer;
        int length = this.indent;
        for (int i = 0; i < length; ++i) {
            writer.append(' ');
        }
    }

    public void appendCommentNewLine(String text) {
        this.appendComment(text, true);
    }

    public void appendComment(String text) {
        this.appendComment(text, false);
    }

    public void appendComment(String text, boolean newLine) {
        StringBuilder comment;
        if (StringsUtil.isEmpty(text) || !this.isEnableComments()) {
            return;
        }
        if (newLine) {
            try {
                this.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((comment = this.comment) == null || comment.length() == 0) {
            this.comment = comment = new StringBuilder();
            if (this.indent != 0 || this.columnNumber != 0) {
                comment.append("    ");
            }
            comment.append('#');
            comment.append(' ');
            this.columnNumber += 2;
        } else {
            comment.append(' ');
            ++this.columnNumber;
        }
        int column = comment.length();
        this.escapeCommentCharacters(comment, text);
        column = comment.length() - column;
        this.columnNumber += column;
    }

    private void escapeCommentCharacters(StringBuilder builder, String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                builder.append('\\');
                builder.append('n');
                continue;
            }
            if (c == '\t') {
                builder.append('\\');
                builder.append('t');
                continue;
            }
            if (c == '\r') {
                builder.append('\\');
                builder.append('r');
                continue;
            }
            if (c == '\b') {
                builder.append('\\');
                builder.append('b');
                continue;
            }
            if (c == '\f') {
                builder.append('\\');
                builder.append('f');
                continue;
            }
            if (c == ' ') {
                builder.append(' ');
                continue;
            }
            if (c < ' ' || !Character.isDefined(c)) {
                DexUtils.encodeToHexChar(builder, c);
                continue;
            }
            builder.append(c);
        }
    }

    public Appendable getCommentAppender() {
        if (!this.isEnableComments()) {
            return null;
        }
        StringBuilder comment = this.comment;
        if (comment == null) {
            this.comment = comment = new StringBuilder();
            if (this.indent != 0 || this.columnNumber != 0) {
                comment.append("    ");
            }
            comment.append('#');
            comment.append(' ');
            this.columnNumber += 2;
        }
        return comment;
    }

    private void flushComment() throws IOException {
        StringBuilder comment = this.comment;
        if (comment == null) {
            return;
        }
        this.append(comment.toString());
        this.comment = null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void indentPlus() {
        this.indent += 4;
    }

    public void indentMinus() {
        this.indent -= 4;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    public void indentReset() {
        this.indent = 0;
    }

    private void write(CharSequence text, int start, int length) throws IOException {
        for (int i = start; i < length; ++i) {
            this.write(text.charAt(i));
        }
    }

    private void write(char ch) throws IOException {
        this.flushIndent();
        this.writer.append(ch);
        ++this.columnNumber;
        this.state_new_line = false;
    }

    public SmaliWriterSetting getWriterSetting() {
        return this.writerSetting;
    }

    public void setWriterSetting(SmaliWriterSetting writerSetting) {
        this.writerSetting = writerSetting;
    }

    public SmaliFileNameFactory getFileNameFactory() {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null) {
            return setting.getFileNameFactory();
        }
        return SmaliFileNameFactory.INSTANCE;
    }

    public boolean isLocalRegistersCount() {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null) {
            return setting.isLocalRegistersCount();
        }
        return true;
    }

    public boolean isEnableComments() {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null) {
            return setting.isEnableComments();
        }
        return true;
    }

    public SequentialLabelFactory getSequentialLabelFactory() {
        return this.sequentialLabelFactory;
    }

    private SequentialLabelFactory getOrCreateSequentialLabelFactory() {
        SequentialLabelFactory labelFactory = this.sequentialLabelFactory;
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null) {
            if (setting.isSequentialLabel()) {
                if (labelFactory == null) {
                    this.sequentialLabelFactory = labelFactory = new SequentialLabelFactory();
                }
            } else {
                labelFactory = null;
            }
        }
        return labelFactory;
    }

    public void setSequentialLabelFactory(SequentialLabelFactory sequentialLabelFactory) {
        this.sequentialLabelFactory = sequentialLabelFactory;
    }

    public boolean isCommentUnicodeStrings() {
        SmaliWriterSetting setting = this.getWriterSetting();
        if (setting != null && setting.isEnableComments() && setting.isCommentUnicodeStrings()) {
            return this.stateWritingFields || this.stateWritingInstructions;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        Writer writer = this.writer;
        if (writer == null) {
            return;
        }
        this.flushComment();
        this.writer = null;
        writer.close();
    }

    public void reset() {
        this.indent = 0;
        this.lineNumber = 1;
        this.columnNumber = 0;
        this.comment = null;
        this.indentRequested = false;
    }

    public RegistersTable getCurrentRegistersTable() {
        return this.currentRegistersTable;
    }

    public void setCurrentRegistersTable(RegistersTable currentRegistersTable) {
        this.currentRegistersTable = currentRegistersTable;
        if (currentRegistersTable == null) {
            this.clearSequentialLabels();
        }
    }

    public void setStateWritingFields(boolean stateWritingFields) {
        this.stateWritingFields = stateWritingFields;
    }

    public void setStateWritingInstructions(boolean stateWritingInstructions) {
        this.stateWritingInstructions = stateWritingInstructions;
    }

    public void buildLabels(Iterator<? extends Label> iterator) {
        SequentialLabelFactory labelFactory = this.getOrCreateSequentialLabelFactory();
        if (labelFactory != null) {
            labelFactory.build(iterator);
        }
    }

    public void clearSequentialLabels() {
        SequentialLabelFactory labelFactory = this.getSequentialLabelFactory();
        if (labelFactory != null) {
            labelFactory.reset();
        }
    }

    public String toString() {
        return "line = " + this.getLineNumber() + ", column = " + this.getColumnNumber();
    }

    public static String toString(SmaliFormat smaliFormat) throws IOException {
        return SmaliWriter.toString(new SmaliWriter(), smaliFormat);
    }

    public static String toString(SmaliWriter writer, SmaliFormat smaliFormat) throws IOException {
        StringWriter stringWriter = new StringWriter();
        writer.setWriter(stringWriter);
        smaliFormat.append(writer);
        writer.close();
        return stringWriter.toString();
    }

    public static String toStringSafe(SmaliFormat smaliFormat) {
        return SmaliWriter.toStringSafe(smaliFormat, true);
    }

    public static String toStringSafe(SmaliFormat smaliFormat, boolean comment) {
        SmaliWriterSetting setting;
        if (smaliFormat == null) {
            return "# null";
        }
        StringWriter stringWriter = new StringWriter();
        SmaliWriter writer = new SmaliWriter(stringWriter);
        if (!comment && (setting = writer.getWriterSetting()) == null) {
            setting = new SmaliWriterSetting();
            setting.setEnableComments(false);
            writer.setWriterSetting(setting);
        }
        try {
            smaliFormat.append(writer);
            writer.close();
            return stringWriter.toString();
        }
        catch (IOException exception) {
            return "# " + exception.toString();
        }
    }
}

