/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.formatters;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.formatters.SmaliComment;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public interface ResourceIdComment
extends SmaliComment {
    public void writeComment(SmaliWriter var1, int var2) throws IOException;

    public static ResourceIdComment of(PackageBlock packageBlock, Locale locale) {
        return new ResourceTableComment(packageBlock, locale);
    }

    public static ResourceIdComment of(PackageBlock packageBlock) {
        return new ResourceTableComment(packageBlock);
    }

    public static class ResourceTableComment
    implements ResourceIdComment {
        private final PackageBlock packageBlock;
        private final TableBlock tableBlock;
        private final Locale locale;
        private final Map<Integer, Object> mCachedComment;
        private final Object mNoComment;

        public ResourceTableComment(PackageBlock packageBlock, Locale locale) {
            this.packageBlock = packageBlock;
            this.tableBlock = packageBlock.getTableBlock();
            if (locale == null) {
                locale = new Locale("en");
            }
            this.locale = locale;
            this.mCachedComment = new HashMap<Integer, Object>();
            this.mNoComment = new Object();
        }

        public ResourceTableComment(PackageBlock packageBlock) {
            this(packageBlock, Locale.getDefault());
        }

        @Override
        public void writeComment(SmaliWriter writer, int resourceId) {
            if (!PackageBlock.isResourceId(resourceId)) {
                return;
            }
            String comment = this.getComment(resourceId);
            if (comment != null) {
                writer.appendComment(comment);
            }
        }

        private String getComment(int resourceId) {
            Map<Integer, Object> map = this.mCachedComment;
            Integer id = resourceId;
            Object obj = map.get(id);
            if (obj == this.mNoComment) {
                return null;
            }
            if (obj != null) {
                return (String)obj;
            }
            String comment = this.buildComment(resourceId);
            obj = comment == null ? this.mNoComment : comment;
            map.put(id, obj);
            return comment;
        }

        private String buildComment(int resourceId) {
            ResourceEntry resourceEntry = this.tableBlock.getResource(resourceId);
            if (resourceEntry == null || !resourceEntry.isDeclared()) {
                return null;
            }
            String ref = resourceEntry.buildReference(this.packageBlock, ValueType.REFERENCE);
            if (!resourceEntry.isContext(this.tableBlock)) {
                return ref;
            }
            if ("id".equals(resourceEntry.getType())) {
                return ref;
            }
            Entry entry = resourceEntry.forLocale(this.locale);
            if (entry == null) {
                return ref;
            }
            ResValue resValue = entry.getResValue();
            if (resValue == null) {
                return ref;
            }
            String decoded = resValue.decodeValue();
            if (decoded == null) {
                return ref;
            }
            if (decoded.length() > 100) {
                decoded = decoded.substring(0, 100) + " ...";
            }
            return ref + " '" + decoded + "'";
        }
    }
}

