/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueFactory;
import java.io.IOException;

public class SmaliAnnotationElement
extends Smali
implements KeyReference {
    private String name;
    private SmaliValue value;

    @Override
    public AnnotationElementKey getKey() {
        return AnnotationElementKey.create(this.getName(), this.getValueKey());
    }

    @Override
    public void setKey(Key key) {
        AnnotationElementKey elementKey = (AnnotationElementKey)key;
        this.setName(elementKey.getName());
        this.setValue(elementKey.getValue());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Key getValueKey() {
        SmaliValue value = this.getValue();
        if (value != null) {
            return value.getKey();
        }
        return null;
    }

    public SmaliValue getValue() {
        return this.value;
    }

    public void setValue(Key key) {
        this.setValue(SmaliValueFactory.createForValue(key));
    }

    public void setValue(SmaliValue value) {
        this.value = value;
        if (value != null) {
            value.setParent(this);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        AnnotationElementKey key = this.getKey();
        if (key == null) {
            writer.append("# error");
        } else {
            key.append(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        int i1 = reader.indexOfWhiteSpace();
        int i2 = reader.indexOf('=');
        int i = i1 < i2 ? i1 : i2;
        int length = i - reader.position();
        this.setName(reader.readString(length));
        reader.skipWhitespaces();
        SmaliParseException.expect(reader, '=');
        reader.skipWhitespaces();
        SmaliValue smaliValue = SmaliValueFactory.create(reader);
        this.setValue(smaliValue);
        smaliValue.parse(reader);
    }
}

