/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliAnnotationElement;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public class SmaliAnnotationItem
extends SmaliSet<SmaliAnnotationElement>
implements KeyReference,
SmaliRegion {
    private SmaliDirective smaliDirective = SmaliDirective.ANNOTATION;
    private AnnotationVisibility visibility = AnnotationVisibility.BUILD;
    private TypeKey type;

    @Override
    public AnnotationItemKey getKey() {
        TypeKey typeKey = this.getType();
        if (typeKey != null) {
            int length = this.size();
            AnnotationElementKey[] elements = new AnnotationElementKey[length];
            for (int i = 0; i < length; ++i) {
                elements[i] = ((SmaliAnnotationElement)this.get(i)).getKey();
            }
            return AnnotationItemKey.create(this.getVisibility(), typeKey, elements);
        }
        return null;
    }

    @Override
    public void setKey(Key key) {
        this.clear();
        AnnotationItemKey itemKey = (AnnotationItemKey)key;
        this.setVisibility(itemKey.getVisibility());
        this.setType(itemKey.getType());
        for (AnnotationElementKey elementKey : itemKey) {
            this.newElement().setKey(elementKey);
        }
    }

    public AnnotationVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(AnnotationVisibility visibility) {
        if (visibility == null) {
            if (this.getParentAnnotationSet() != null) {
                throw new NullPointerException("Null AnnotationVisibility");
            }
            this.smaliDirective = SmaliDirective.SUB_ANNOTATION;
        } else {
            this.smaliDirective = SmaliDirective.ANNOTATION;
        }
        this.visibility = visibility;
    }

    public TypeKey getType() {
        return this.type;
    }

    public void setType(TypeKey type) {
        this.type = type;
    }

    public boolean hasElement(String name) {
        return this.get(name) != null;
    }

    public SmaliAnnotationElement get(String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SmaliAnnotationElement element = (SmaliAnnotationElement)this.get(i);
            if (!ObjectsUtil.equals(element.getName(), name)) continue;
            return element;
        }
        return null;
    }

    public SmaliAnnotationElement newElement() {
        SmaliAnnotationElement element = new SmaliAnnotationElement();
        this.add(element);
        return element;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return this.smaliDirective;
    }

    public SmaliAnnotationSet getParentAnnotationSet() {
        Smali parent = this.getParent();
        if (parent instanceof SmaliAnnotationSet) {
            return (SmaliAnnotationSet)parent;
        }
        return null;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        AnnotationItemKey key = this.getKey();
        if (key != null) {
            key.append(writer);
        } else {
            this.getSmaliDirective().append(writer);
            writer.appendOptional(this.getVisibility());
            writer.appendOptional(this.getType());
            writer.appendAllWithIndent(this.iterator());
            this.getSmaliDirective().appendEnd(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        TypeKey typeKey;
        SmaliAnnotationItem duplicate;
        int position = reader.position();
        AnnotationItemKey itemKey = AnnotationItemKey.read(reader);
        SmaliDirective directive = this.getSmaliDirective();
        SmaliAnnotationSet parent = this.getParentAnnotationSet();
        if (parent != null) {
            directive = SmaliDirective.ANNOTATION;
        }
        if (directive != itemKey.getSmaliDirective()) {
            reader.position(position);
            throw new SmaliParseException("Expecting: " + directive, reader);
        }
        if (parent != null && (duplicate = parent.get(typeKey = itemKey.getType())) != null && duplicate != this) {
            reader.position(position);
            throw new SmaliParseException("Duplicate annotation: " + typeKey, reader);
        }
        this.setKey(itemKey);
    }

    @Override
    SmaliAnnotationElement createNext(SmaliReader reader) {
        reader.skipWhitespacesOrComment();
        if (reader.finished()) {
            return null;
        }
        if (this.getSmaliDirective().isEnd(reader)) {
            return null;
        }
        return new SmaliAnnotationElement();
    }
}

