/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.program.ClassProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliField;
import com.reandroid.dex.smali.model.SmaliFieldSet;
import com.reandroid.dex.smali.model.SmaliInterfaceSet;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliMethodSet;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.util.Iterator;

public class SmaliClass
extends SmaliDef
implements ClassProgram {
    private TypeKey superClass;
    private StringKey sourceFile;
    private final SmaliInterfaceSet interfaces = new SmaliInterfaceSet();
    private final SmaliFieldSet fields = new SmaliFieldSet();
    private final SmaliMethodSet methods = new SmaliMethodSet();

    public SmaliClass() {
        this.interfaces.setParent(this);
        this.fields.setParent(this);
        this.methods.setParent(this);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.TYPE;
    }

    @Override
    public TypeKey getKey() {
        return TypeKey.create(this.getName());
    }

    public void setKey(TypeKey key) {
        String name = key != null ? key.getTypeName() : null;
        this.setName(name);
    }

    @Override
    public TypeKey getSuperClassKey() {
        return this.superClass;
    }

    public void setSuperClass(TypeKey typeKey) {
        this.superClass = typeKey;
    }

    @Override
    public String getSourceFileName() {
        StringKey key = this.getSourceFileKey();
        if (key != null) {
            return key.getString();
        }
        return null;
    }

    public StringKey getSourceFileKey() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        StringKey key = sourceFile == null ? null : StringKey.create(sourceFile);
        this.setSourceFile(key);
    }

    public void setSourceFile(StringKey sourceFile) {
        this.sourceFile = sourceFile;
    }

    public SmaliInterfaceSet getInterfaces() {
        return this.interfaces;
    }

    @Override
    public TypeListKey getInterfacesKey() {
        return this.getInterfaces().getKey();
    }

    public void setInterfaces(TypeListKey key) {
        this.getInterfaces().setKey(key);
    }

    public boolean hasClassData() {
        return !this.fields.isEmpty() || !this.methods.isEmpty();
    }

    public Iterator<SmaliField> getStaticFields() {
        return this.fields.getStaticFields();
    }

    public Iterator<SmaliField> getInstanceFields() {
        return this.fields.getInstanceFields();
    }

    public void addFields(Iterator<SmaliField> iterator) {
        this.fields.addAll(iterator);
    }

    public Iterator<SmaliMethod> getDirectMethods() {
        return this.methods.getDirectMethods();
    }

    public Iterator<SmaliMethod> getVirtualMethods() {
        return this.methods.getVirtualMethods();
    }

    public void addMethods(Iterator<SmaliMethod> iterator) {
        this.methods.addAll(iterator);
    }

    public SmaliMethod getStaticConstructor() {
        Iterator<SmaliMethod> iterator = this.getDirectMethods();
        while (iterator.hasNext()) {
            SmaliMethod method = iterator.next();
            if (!method.isConstructor() || !method.isStatic() || !MethodKey.CONSTRUCTOR_STATIC.equalsIgnoreDeclaring(method.getKey())) continue;
            return method;
        }
        return null;
    }

    void fixUninitializedFinalFields() {
        Iterator<SmaliField> iterator = this.getStaticFields();
        while (iterator.hasNext()) {
            iterator.next().fixUninitializedFinalValue();
        }
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.CLASS;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        Modifier.append(writer, this.getAccessFlags());
        writer.appendOptional(this.getKey());
        writer.newLine();
        SmaliDirective.SUPER.append(writer);
        writer.appendOptional(this.getSuperClassKey());
        StringKey source = this.getSourceFileKey();
        if (source != null) {
            writer.newLine();
            SmaliDirective.SOURCE.append(writer);
            source.append(writer);
        }
        this.getInterfaces().append(writer);
        if (this.hasAnnotation()) {
            writer.newLine();
            writer.appendCommentNewLine("annotations");
            writer.appendAllWithDoubleNewLine(this.getAnnotationSet().iterator());
        }
        this.fields.append(writer);
        this.methods.append(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, SmaliDirective.CLASS);
        this.setAccessFlags(AccessFlag.parse(reader));
        this.setKey(TypeKey.read(reader));
        while (this.parseNext(reader)) {
            reader.skipWhitespacesOrComment();
        }
        reader.skipWhitespacesOrComment();
        if (!reader.finished() && !SmaliDirective.CLASS.is(SmaliDirective.parse(reader, false))) {
            throw new SmaliParseException("Unexpected character", reader);
        }
        this.fixUninitializedFinalFields();
    }

    private boolean parseNext(SmaliReader reader) throws IOException {
        if (reader.finished()) {
            return false;
        }
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive == SmaliDirective.CLASS) {
            return false;
        }
        if (directive == SmaliDirective.SUPER) {
            this.parseSuper(reader);
            return true;
        }
        if (directive == SmaliDirective.SOURCE) {
            this.parseSource(reader);
            return true;
        }
        if (directive == SmaliDirective.ANNOTATION) {
            this.getOrCreateSmaliAnnotationSet().parse(reader);
            return true;
        }
        if (directive == SmaliDirective.FIELD) {
            this.fields.parse(reader);
            return true;
        }
        if (directive == SmaliDirective.METHOD) {
            this.methods.parse(reader);
            return true;
        }
        if (directive == SmaliDirective.IMPLEMENTS) {
            this.interfaces.parse(reader);
            return true;
        }
        return false;
    }

    private void parseSuper(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, SmaliDirective.SUPER);
        this.setSuperClass(TypeKey.read(reader));
    }

    private void parseSource(SmaliReader reader) throws IOException {
        SmaliParseException.expect(reader, SmaliDirective.SOURCE);
        reader.skipSpaces();
        this.setSourceFile(StringKey.read(reader));
    }

    public SmaliField parseField(SmaliReader reader) throws IOException {
        return (SmaliField)this.fields.parseNext(reader);
    }

    public SmaliMethod parseMethod(SmaliReader reader) throws IOException {
        return (SmaliMethod)this.methods.parseNext(reader);
    }

    @Override
    public String toDebugString() {
        return "class = " + this.getKey();
    }
}

