/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliLabel;
import java.io.IOException;

public abstract class SmaliCodeExceptionHandler
extends SmaliCode
implements SmaliRegion {
    private final SmaliLabel start = new SmaliLabel();
    private final SmaliLabel end = new SmaliLabel();
    private final SmaliLabel catchLabel = new SmaliLabel();

    public SmaliCodeExceptionHandler() {
        this.start.setParent(this);
        this.end.setParent(this);
        this.catchLabel.setParent(this);
    }

    public int getAddress() {
        SmaliCodeTryItem tryItem = this.getTryItem();
        if (tryItem == null) {
            return -1;
        }
        return tryItem.getAddress();
    }

    public SmaliLabel getStart() {
        return this.start;
    }

    public SmaliLabel getEnd() {
        return this.end;
    }

    public SmaliLabel getCatchLabel() {
        return this.catchLabel;
    }

    SmaliCodeTryItem getTryItem() {
        return this.getParentInstance(SmaliCodeTryItem.class);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        this.appendType(writer);
        writer.append('{');
        this.getStart().append(writer);
        writer.append(" .. ");
        this.getEnd().append(writer);
        writer.append('}');
        writer.append(' ');
        this.getCatchLabel().append(writer);
    }

    public void appendType(SmaliWriter writer) throws IOException {
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        SmaliParseException.expect(reader, this.getSmaliDirective());
        this.parseType(reader);
        reader.skipSpaces();
        SmaliParseException.expect(reader, '{');
        this.getStart().parse(reader);
        reader.skipSpaces();
        SmaliParseException.expect(reader, '.');
        SmaliParseException.expect(reader, '.');
        this.getEnd().parse(reader);
        reader.skipSpaces();
        SmaliParseException.expect(reader, '}');
        this.getCatchLabel().parse(reader);
    }

    void parseType(SmaliReader reader) throws IOException {
    }
}

