/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliSet;
import java.io.IOException;
import java.util.Iterator;

public abstract class SmaliInstructionPayload<T extends Smali>
extends SmaliInstruction
implements SmaliRegion {
    private final SmaliInstructionOperand operand;
    private final SmaliSet<T> entries;

    public SmaliInstructionPayload(SmaliInstructionOperand operand) {
        this.operand = operand;
        this.entries = new SmaliSet();
        this.operand.setParent(this);
        this.entries.setParent(this);
    }

    @Override
    public abstract int getCodeUnits();

    @Override
    public abstract Opcode<?> getOpcode();

    abstract T createEntry();

    public void addEntry(T entry) {
        this.getEntries().add(entry);
    }

    public T getEntry(int i) {
        return this.getEntries().get(i);
    }

    public int getCount() {
        return this.getEntries().size();
    }

    public Iterator<T> entries() {
        return this.getEntries().iterator();
    }

    @Override
    public SmaliInstructionOperand getOperand() {
        return this.operand;
    }

    public SmaliSet<T> getEntries() {
        return this.entries;
    }

    public T newEntry() {
        T entry = this.createEntry();
        this.addEntry(entry);
        return entry;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        this.getOperand().append(writer);
        writer.indentPlus();
        this.getEntries().append(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        this.setOrigin(reader.getCurrentOrigin());
        SmaliDirective directive = this.getSmaliDirective();
        SmaliParseException.expect(reader, directive);
        reader.skipSpaces();
        this.parseOperand(this.getOpcode(), reader);
        reader.skipWhitespacesOrComment();
        while (!directive.isEnd(reader)) {
            this.newEntry().parse(reader);
            reader.skipWhitespacesOrComment();
        }
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, this.getSmaliDirective(), true);
    }

    void parseOperand(Opcode<?> opcode, SmaliReader reader) throws IOException {
        this.getOperand().parse(opcode, reader);
    }
}

