/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInterface;
import com.reandroid.dex.smali.model.SmaliSet;
import java.io.IOException;

public class SmaliInterfaceSet
extends SmaliSet<SmaliInterface>
implements SmaliRegion,
Iterable<SmaliInterface> {
    public TypeListKey getKey() {
        int size = this.size();
        if (size == 0) {
            return TypeListKey.empty();
        }
        Key[] keys = new TypeKey[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = ((SmaliInterface)this.get(i)).getKey();
        }
        return TypeListKey.create(keys);
    }

    public void setKey(Key key) {
        this.clear();
        if (key == null) {
            return;
        }
        TypeListKey typeListKey = (TypeListKey)key;
        int size = typeListKey.size();
        for (int i = 0; i < size; ++i) {
            this.createNew().setKey((Key)typeListKey.get(i));
        }
    }

    public SmaliInterface createNew() {
        SmaliInterface smaliInterface = new SmaliInterface();
        this.add(smaliInterface);
        return smaliInterface;
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.IMPLEMENTS;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.newLine();
        writer.newLine();
        writer.newLine();
        writer.appendComment("interfaces");
        writer.newLine();
        writer.appendAll(this.iterator());
    }

    @Override
    SmaliInterface createNext(SmaliReader reader) {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != this.getSmaliDirective()) {
            return null;
        }
        return new SmaliInterface();
    }

    public static SmaliInterfaceSet read(SmaliReader reader) throws IOException {
        SmaliInterfaceSet smali = new SmaliInterfaceSet();
        smali.parse(reader);
        if (!smali.isEmpty()) {
            return smali;
        }
        return null;
    }
}

