/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.HiddenApiFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.key.AnnotationGroupKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.MethodProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.SmaliWriterSetting;
import com.reandroid.dex.smali.fix.SmaliGotoFix;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliCodeSet;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliDebugElement;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.dex.smali.model.SmaliParamSet;
import java.io.IOException;
import java.util.Iterator;

public class SmaliMethod
extends SmaliDef
implements MethodProgram,
RegistersTable {
    private ProtoKey protoKey;
    private final SmaliParamSet paramSet = new SmaliParamSet();
    private final SmaliRegistersCount smaliRegistersCount = new SmaliRegistersCount();
    private final SmaliCodeSet codeSet = new SmaliCodeSet();

    public SmaliMethod() {
        this.paramSet.setParent(this);
        this.smaliRegistersCount.setParent(this);
        this.codeSet.setParent(this);
    }

    @Override
    public MethodKey getKey() {
        TypeKey typeKey = this.getDefining();
        if (typeKey != null) {
            return this.getKey(typeKey);
        }
        return null;
    }

    public void setKey(Key key) {
        MethodKey methodKey = (MethodKey)key;
        this.setName(methodKey.getNameKey());
        this.setProtoKey(methodKey.getProto());
        this.setDefining(methodKey.getDeclaring());
    }

    public MethodKey getKey(TypeKey declaring) {
        return MethodKey.create(declaring, this.getName(), this.getProtoKey());
    }

    public boolean hasParameterAnnotations() {
        return this.getParamSet().hasParameterAnnotations();
    }

    public AnnotationGroupKey getParameterAnnotations() {
        return this.getParamSet().getParameterAnnotations(this);
    }

    public boolean hasInstructions() {
        return this.getInstructions().hasNext();
    }

    public Iterator<SmaliInstruction> getInstructions() {
        return this.getCodeSet().getInstructions();
    }

    public boolean hasDebugElements() {
        return this.getDebugElements().hasNext();
    }

    public Iterator<SmaliDebugElement> getDebugElements() {
        return this.getCodeSet().getDebugElements();
    }

    public SmaliRegistersCount getSmaliRegistersCount() {
        return this.smaliRegistersCount;
    }

    @Override
    public ProtoKey getProtoKey() {
        return this.protoKey;
    }

    public void setProtoKey(ProtoKey protoKey) {
        this.protoKey = protoKey;
    }

    public SmaliParamSet getParamSet() {
        return this.paramSet;
    }

    @Override
    public int getParametersCount() {
        ProtoKey protoKey = this.getProtoKey();
        if (protoKey != null) {
            return protoKey.getParametersCount();
        }
        return this.getParamSet().size();
    }

    @Override
    public SmaliMethodParameter getParameter(int i) {
        return (SmaliMethodParameter)this.getParamSet().get(i);
    }

    public Iterator<SmaliMethodParameter> getParameters() {
        return this.getParamSet().iterator();
    }

    public SmaliCodeSet getCodeSet() {
        return this.codeSet;
    }

    public Iterator<SmaliCodeTryItem> getTryItems() {
        return this.getCodeSet().getTryItems();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.METHOD;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        Modifier.append(writer, this.getModifiers());
        writer.append(this.getName());
        this.getProtoKey().append(writer);
        writer.indentPlus();
        if (this.hasInstructions()) {
            writer.newLine();
            this.getSmaliRegistersCount().append(writer);
        }
        this.getParamSet().append(writer);
        if (this.hasAnnotation()) {
            writer.newLine();
            this.getAnnotationSet().append(writer);
        }
        this.getCodeSet().append(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, this.getSmaliDirective());
        this.setAccessFlags(AccessFlag.parse(reader));
        this.setHiddenApiFlags(HiddenApiFlag.parse(reader));
        this.setName(StringKey.readSimpleName(reader, '('));
        this.parseProto(reader);
        reader.skipWhitespacesOrComment();
        while (this.parseNoneCode(reader)) {
            reader.skipWhitespacesOrComment();
        }
        this.getCodeSet().parse(reader);
        SmaliParseException.expect(reader, this.getSmaliDirective(), true);
        this.runFixes();
    }

    private void runFixes() {
        new SmaliGotoFix(this).apply();
    }

    private boolean parseNoneCode(SmaliReader reader) throws IOException {
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive == SmaliDirective.LOCALS || directive == SmaliDirective.REGISTERS) {
            this.getSmaliRegistersCount().parse(reader);
            return true;
        }
        if (directive == SmaliDirective.ANNOTATION) {
            this.getOrCreateSmaliAnnotationSet().parse(reader);
            return true;
        }
        if (directive == SmaliDirective.PARAM) {
            this.getParamSet().parse(reader);
            return true;
        }
        return false;
    }

    private void parseProto(SmaliReader reader) throws IOException {
        reader.skipWhitespaces();
        this.setProtoKey(ProtoKey.read(reader));
    }

    @Override
    public int getRegistersCount() {
        return this.getSmaliRegistersCount().getRegisters();
    }

    @Override
    public int getParameterRegistersCount() {
        int count = this.isStatic() ? 0 : 1;
        ProtoKey protoKey = this.getProtoKey();
        if (protoKey != null) {
            count += protoKey.getParameterRegistersCount();
        }
        return count;
    }

    @Override
    public void setRegistersCount(int count) {
    }

    @Override
    public void setParameterRegistersCount(int count) {
    }

    @Override
    public boolean ensureLocalRegistersCount(int count) {
        return true;
    }

    @Override
    public int getLocalRegistersCount() {
        return this.getSmaliRegistersCount().getLocals();
    }

    @Override
    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        TypeKey typeKey = this.getDefining();
        if (typeKey != null) {
            builder.append(typeKey);
            builder.append(", ");
        }
        builder.append("method = ");
        builder.append(this.getName());
        builder.append(this.getProtoKey());
        return builder.toString();
    }

    public static class SmaliRegistersCount
    extends Smali
    implements SmaliRegion {
        private SmaliDirective directive = SmaliDirective.LOCALS;
        private int value;

        public int getLocals() {
            int value = this.getValue();
            if (!this.isLocalsMode()) {
                SmaliMethod method = this.getParent(SmaliMethod.class);
                value -= method.getParameterRegistersCount();
            }
            return value;
        }

        public int getRegisters() {
            int value = this.getValue();
            if (this.isLocalsMode()) {
                SmaliMethod method = this.getParent(SmaliMethod.class);
                value += method.getParameterRegistersCount();
            }
            return value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public boolean isLocalsMode() {
            return this.getSmaliDirective() == SmaliDirective.LOCALS;
        }

        public void setLocalsMode(boolean localsMode) {
            SmaliDirective directive;
            int value;
            if (localsMode == this.isLocalsMode()) {
                return;
            }
            if (localsMode) {
                value = this.getLocals();
                directive = SmaliDirective.LOCALS;
            } else {
                value = this.getRegisters();
                directive = SmaliDirective.REGISTERS;
            }
            this.setDirective(directive);
            this.setValue(value);
        }

        private void setDirective(SmaliDirective directive) {
            this.directive = directive;
        }

        @Override
        public void parse(SmaliReader reader) throws IOException {
            SmaliDirective directive = SmaliDirective.parse(reader);
            if (directive != SmaliDirective.LOCALS && directive != SmaliDirective.REGISTERS) {
                throw new SmaliParseException("expecting '" + SmaliDirective.LOCALS + "', or '" + SmaliDirective.REGISTERS + "'", reader);
            }
            this.setDirective(directive);
            reader.skipSpaces();
            this.setValue(reader.readInteger());
        }

        @Override
        public SmaliDirective getSmaliDirective() {
            return this.directive;
        }

        @Override
        public void append(SmaliWriter writer) throws IOException {
            SmaliWriterSetting setting = writer.getWriterSetting();
            if (setting != null) {
                this.setLocalsMode(setting.isLocalRegistersCount());
            }
            this.getSmaliDirective().append(writer);
            writer.appendInteger(this.getValue());
        }
    }
}

