/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.MethodParameter;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliParamSet;
import com.reandroid.dex.smali.model.SmaliRegister;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class SmaliMethodParameter
extends SmaliDebug
implements MethodParameter,
SmaliRegion {
    private final SmaliRegister smaliRegister;
    private StringKey name;
    private SmaliAnnotationSet annotationSet;

    public SmaliMethodParameter() {
        SmaliRegister register = new SmaliRegister();
        register.setParameter(true);
        register.setNumber(-1);
        this.smaliRegister = register;
    }

    @Override
    public TypeKey getKey() {
        SmaliMethod smaliMethod = this.getParentInstance(SmaliMethod.class);
        if (smaliMethod == null) {
            return null;
        }
        ProtoKey protoKey = smaliMethod.getProtoKey();
        if (protoKey == null) {
            return null;
        }
        SmaliRegister smaliRegister = this.getSmaliRegister();
        int index = smaliRegister.getNumber();
        if (!smaliMethod.isStatic()) {
            --index;
        }
        return protoKey.getParameter(protoKey.getParameterIndex(index));
    }

    public SmaliRegister getSmaliRegister() {
        return this.smaliRegister;
    }

    public StringKey getNameKey() {
        return this.name;
    }

    public void setName(StringKey name) {
        this.name = name;
    }

    @Override
    public String getDebugName() {
        StringKey key = this.getNameKey();
        if (key != null) {
            return key.getString();
        }
        return null;
    }

    @Override
    public void setDebugName(String name) {
        if (StringsUtil.isEmpty(name)) {
            name = null;
        }
        StringKey key = name == null ? null : StringKey.create(name);
        this.setName(key);
    }

    @Override
    public boolean hasAnnotations() {
        SmaliAnnotationSet annotationSet = this.getSmaliAnnotationSet();
        return annotationSet != null && !annotationSet.isEmpty();
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        SmaliAnnotationSet annotationSet = this.getSmaliAnnotationSet();
        if (annotationSet != null) {
            return annotationSet.getKey();
        }
        return AnnotationSetKey.empty();
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotation) {
        if (annotation == null || annotation.isEmpty()) {
            this.setSmaliAnnotationSet(null);
        } else {
            this.getOrCreateSmaliAnnotationSet().setKey(annotation);
        }
    }

    @Override
    public void clearAnnotations() {
        this.setSmaliAnnotationSet(null);
    }

    public SmaliAnnotationSet getSmaliAnnotationSet() {
        return this.annotationSet;
    }

    public SmaliAnnotationSet getOrCreateSmaliAnnotationSet() {
        SmaliAnnotationSet annotationSet = this.getSmaliAnnotationSet();
        if (annotationSet == null) {
            annotationSet = new SmaliAnnotationSet();
            this.setSmaliAnnotationSet(annotationSet);
        }
        return annotationSet;
    }

    public void setSmaliAnnotationSet(SmaliAnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
        if (annotationSet != null) {
            annotationSet.setParent(this);
        }
    }

    @Override
    public int getDefinitionIndex() {
        SmaliMethod smaliMethod = this.getParentInstance(SmaliMethod.class);
        if (smaliMethod == null) {
            return -1;
        }
        ProtoKey protoKey = smaliMethod.getProtoKey();
        if (protoKey == null) {
            return -1;
        }
        return this.getDefinitionIndex(smaliMethod.isStatic(), protoKey);
    }

    public int getDefinitionIndex(boolean is_static, ProtoKey protoKey) {
        int index = this.getRegister();
        if (!is_static) {
            --index;
        }
        return protoKey.getParameterIndex(index);
    }

    @Override
    public int getRegister() {
        return this.getSmaliRegister().getNumber();
    }

    public void setRegister(int register) {
        this.getSmaliRegister().setNumber(register);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PARAM;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        SmaliAnnotationSet annotationSet;
        SmaliDirective directive = this.getSmaliDirective();
        directive.append(writer);
        this.getSmaliRegister().append(writer);
        StringKey name = this.getNameKey();
        if (name != null) {
            writer.append(", ");
            name.append(writer);
        }
        if ((annotationSet = this.getSmaliAnnotationSet()) != null) {
            writer.indentPlus();
            writer.newLine();
            annotationSet.append(writer);
            writer.indentMinus();
            directive.appendEnd(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        super.parse(reader);
        this.getSmaliRegister().parse(reader);
        this.validateRegister(reader);
        reader.skipWhitespacesOrComment();
        if (reader.get() == 44) {
            reader.skip(1);
            reader.skipWhitespacesOrComment();
        }
        this.parseName(reader);
        this.parseAnnotationSet(reader);
        AnnotationItemKey duplicate = (AnnotationItemKey)this.getAnnotation().getDuplicate();
        if (duplicate != null) {
            throw new SmaliParseException("Multiple annotation of type: " + duplicate.getType() + "\n", reader);
        }
    }

    private void validateRegister(SmaliReader reader) throws IOException {
        SmaliRegister register = this.getSmaliRegister();
        if (!register.isParameter()) {
            throw new SmaliParseException("Unexpected parameter register type: " + register + "\n", reader);
        }
        SmaliParamSet paramSet = this.getParentInstance(SmaliParamSet.class);
        if (paramSet != null && paramSet.isDuplicateRegister(this)) {
            throw new SmaliParseException("Duplicate parameter register: " + register + "\n", reader);
        }
        SmaliMethod smaliMethod = this.getParentInstance(SmaliMethod.class);
        if (smaliMethod == null) {
            return;
        }
        ProtoKey protoKey = smaliMethod.getProtoKey();
        if (protoKey == null) {
            return;
        }
        boolean is_static = smaliMethod.isStatic();
        int max = protoKey.getParameterRegistersCount();
        if (is_static) {
            --max;
        }
        if (register.getNumber() > max) {
            throw new SmaliParseException("Register " + register + " is larger than the maximum register p" + max + " for this method", reader);
        }
        int index = this.getDefinitionIndex(is_static, protoKey);
        if (index < 0) {
            TypeKey typeKey;
            index = register.getNumber();
            if (index == 0 && !is_static) {
                throw new SmaliParseException("Register " + register + " is not a parameter register.", reader);
            }
            --index;
            if (!is_static) {
                --index;
            }
            if ((typeKey = protoKey.getParameter(protoKey.getParameterIndex(index))) != null && typeKey.isWide()) {
                throw new SmaliParseException("Register " + register + " is the second half of a wide parameter " + typeKey, reader);
            }
            throw new SmaliParseException("Parameter register out of range: " + register + "\n", reader);
        }
    }

    private void parseName(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        if (reader.get() == 34) {
            this.setName(StringKey.read(reader));
        }
    }

    private void parseAnnotationSet(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != SmaliDirective.ANNOTATION) {
            return;
        }
        int position = reader.position();
        SmaliAnnotationSet annotationSet = new SmaliAnnotationSet();
        annotationSet.parse(reader);
        reader.skipWhitespacesOrComment();
        if (this.getSmaliDirective().isEnd(reader)) {
            this.setSmaliAnnotationSet(annotationSet);
            SmaliDirective.parse(reader);
        } else {
            reader.position(position);
        }
    }
}

