/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.AnnotationGroupKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.dex.smali.model.SmaliSet;
import java.util.Iterator;

public class SmaliParamSet
extends SmaliSet<SmaliMethodParameter> {
    public boolean isDuplicateRegister(SmaliMethodParameter parameter) {
        int size = this.size();
        int number = parameter.getRegister();
        for (int i = 0; i < size; ++i) {
            SmaliMethodParameter p = (SmaliMethodParameter)this.get(i);
            if (p == parameter || number != p.getRegister()) continue;
            return true;
        }
        return false;
    }

    public boolean hasParameterAnnotations() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!((SmaliMethodParameter)this.get(i)).hasAnnotations()) continue;
            return true;
        }
        return false;
    }

    public AnnotationGroupKey getParameterAnnotations() {
        return this.getParameterAnnotations(this.getParentInstance(SmaliMethod.class));
    }

    public AnnotationGroupKey getParameterAnnotations(SmaliMethod smaliMethod) {
        if (this.isEmpty()) {
            return AnnotationGroupKey.empty();
        }
        if (smaliMethod == null) {
            return AnnotationGroupKey.empty();
        }
        ProtoKey protoKey = smaliMethod.getProtoKey();
        if (protoKey == null || protoKey.getParametersCount() == 0) {
            return AnnotationGroupKey.empty();
        }
        boolean is_static = smaliMethod.isStatic();
        AnnotationSetKey[] elements = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SmaliMethodParameter parameter = (SmaliMethodParameter)iterator.next();
            int i = parameter.getDefinitionIndex(is_static, protoKey);
            if (i < 0) {
                return AnnotationGroupKey.empty();
            }
            AnnotationSetKey setKey = parameter.getAnnotation();
            if (setKey.isEmpty()) continue;
            if (elements == null) {
                elements = new AnnotationSetKey[protoKey.getParametersCount()];
            }
            elements[i] = setKey;
        }
        return AnnotationGroupKey.of(elements);
    }

    @Override
    SmaliMethodParameter createNext(SmaliReader reader) {
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive == SmaliDirective.PARAM) {
            return new SmaliMethodParameter();
        }
        return null;
    }
}

