/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.value.DexValueType;
import java.io.IOException;

public class SmaliValueBoolean
extends SmaliValue {
    private boolean value;

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public PrimitiveKey getKey() {
        return PrimitiveKey.of(this.getValue());
    }

    @Override
    public void setKey(Key key) {
        this.setValue(((PrimitiveKey.BooleanKey)key).value());
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.BOOLEAN;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (this.getValue()) {
            writer.append("true");
        } else {
            writer.append("false");
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        byte[] bytes = new byte[]{102, 97, 108, 115, 101};
        if (reader.startsWith(bytes)) {
            reader.skip(bytes.length);
            this.setValue(false);
        } else {
            bytes = new byte[]{116, 114, 117, 101};
            if (reader.startsWith(bytes)) {
                reader.skip(bytes.length);
                this.setValue(true);
            } else {
                throw new SmaliParseException("Not boolean value", reader);
            }
        }
    }
}

