/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueChar;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import java.io.IOException;

public class CharValue
extends PrimitiveValueBlock {
    public CharValue() {
        super(DexValueType.CHAR);
    }

    public char get() {
        return (char)(this.getUnsigned() & 0xFFFFL);
    }

    public void set(char ch) {
        this.setUnsignedValue(0xFFFF & ch);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.CHAR;
    }

    @Override
    public PrimitiveKey getKey() {
        return PrimitiveKey.of(this.get());
    }

    @Override
    public void setKey(Key key) {
        this.set(((PrimitiveKey.CharKey)key).value());
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_C;
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueChar smaliValueChar = (SmaliValueChar)smaliValue;
        this.set(smaliValueChar.getValue());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        DexUtils.appendSingleQuotedChar(writer, this.get());
    }

    @Override
    public String toString() {
        return DexUtils.quoteChar(this.get());
    }
}

