/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public class DexValueBlock<T extends Block>
extends FixedBlockContainer
implements KeyReference,
SmaliFormat {
    private final ByteItem valueTypeItem = new ByteItem();
    private final T valueContainer;

    DexValueBlock(T value, DexValueType<?> type) {
        super(2);
        this.valueContainer = value;
        this.addChild(0, this.valueTypeItem);
        this.addChild(1, (Block)this.valueContainer);
        this.valueTypeItem.set((byte)type.getFlag(0));
    }

    DexValueBlock(DexValueType<?> type) {
        this(null, type);
    }

    T getValueContainer() {
        return this.valueContainer;
    }

    ByteItem getValueTypeItem() {
        return this.valueTypeItem;
    }

    public DexValueType<?> getValueType() {
        return this.getValueTypeReal();
    }

    private DexValueType<?> getValueTypeReal() {
        return DexValueType.fromFlag(this.valueTypeItem.get());
    }

    int getValueSize() {
        return DexValueType.decodeSize(this.valueTypeItem.get());
    }

    void setValueSize(int size) {
        int flag = this.getValueType().getFlag(size);
        this.valueTypeItem.set((byte)flag);
    }

    @Override
    public Key getKey() {
        throw new RuntimeException("Method not implemented: " + this.getClass());
    }

    @Override
    public void setKey(Key key) {
        throw new RuntimeException("Method not implemented: " + this.getClass());
    }

    public void replaceKeys(Key search, Key replace) {
    }

    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    public void merge(DexValueBlock<?> valueBlock) {
        this.valueTypeItem.set(valueBlock.valueTypeItem.getByte());
    }

    public void fromSmali(SmaliValue smaliValue) {
        throw new RuntimeException("Method not implemented: " + this.getClass().getSimpleName());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getKey().append(writer);
    }

    public boolean is(DexValueType<?> dexValueType) {
        return dexValueType == this.getValueType();
    }

    public TypeKey getDataTypeKey() {
        return TypeKey.OBJECT;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getValueType().getType();
        hash = hash * 31 + this.getValueContainer().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexValueBlock value = (DexValueBlock)obj;
        return ObjectsUtil.equals(this.getValueContainer(), value.getValueContainer());
    }

    public String toString() {
        return String.valueOf(this.getValueContainer());
    }
}

