/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.SectionIdValue;

public class StringValue
extends SectionIdValue<StringId> {
    public StringValue() {
        super(SectionType.STRING_ID, DexValueType.STRING);
    }

    @Override
    public StringKey getKey() {
        return (StringKey)super.getKey();
    }

    public String getString() {
        StringKey stringKey = this.getKey();
        if (stringKey != null) {
            return stringKey.getString();
        }
        return null;
    }

    public void setString(String value) {
        this.setKey(StringKey.create(value));
    }

    @Override
    void updateUsageType(StringId stringId) {
        AnnotationItem annotationItem;
        super.updateUsageType(stringId);
        if (stringId != null && stringId.containsUsage(UsageMarker.USAGE_ANNOTATION) && !stringId.containsUsage(UsageMarker.USAGE_SIGNATURE_TYPE) && (annotationItem = this.getParentInstance(AnnotationItem.class)) != null && TypeKey.DALVIK_Signature.equals(annotationItem.getType())) {
            stringId.addUsageType(UsageMarker.USAGE_SIGNATURE_TYPE);
        }
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.STRING;
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.STRING;
    }
}

