/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.model.ResourceName;
import com.reandroid.arsc.refactor.ResourceBuilder;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.BaseApkModuleProcessor;
import com.reandroid.graph.InlineFieldIntResolver;
import com.reandroid.graph.RequiredEntriesScanner;
import com.reandroid.graph.VitalClassesSet;
import com.reandroid.graph.cleaners.UnusedAnnotationCleaner;
import com.reandroid.graph.cleaners.UnusedClassesCleaner;
import com.reandroid.graph.cleaners.UnusedFieldsCleaner;
import com.reandroid.graph.cleaners.UnusedMethodsCleaner;
import com.reandroid.utils.collection.CollectionUtil;
import java.util.List;
import java.util.Set;

public class ApkBuilder
extends BaseApkModuleProcessor {
    private ApkBuildOption buildOption;
    private VitalClassesSet vitalClassesSet;
    private static final int MAX_CYCLE = 25;

    public ApkBuilder(ApkModule sourceModule, DexClassRepository classRepository) {
        super(sourceModule, classRepository);
    }

    @Override
    public void apply() {
        int filesCount = this.getApkModule().getZipEntryMap().size();
        this.resolveInlineIntegerFieldCalls();
        this.cleanDex();
        ResourceMergeOption resourceMergeOption = this.getBuildOption().getResourceMergeOption();
        ResourceBuilder resourceBuilder = new ResourceBuilder(resourceMergeOption, this.getApkModule().getTableBlock());
        this.cleanUnusedResFiles();
        this.initializeRequiredIds();
        resourceBuilder.rebuild();
        ApkModule sourceModule = this.getApkModule();
        resourceBuilder.rebuildManifest(sourceModule);
        resourceBuilder.applyIdChanges(this.getClassRepository().visitIntegers());
        ApkModule resultModule = resourceBuilder.getResultModule();
        this.removeResFiles();
        sourceModule.setTableBlock(resultModule.getTableBlock());
        sourceModule.keepTableBlockChanges();
        resultModule.setTableBlock(null);
        sourceModule.getZipEntryMap().addAll(resultModule.getZipEntryMap());
        this.verbose("Removed files: " + (filesCount -= sourceModule.getZipEntryMap().size()));
    }

    private void cleanDex() {
        int countTotal = 0;
        int count = 1;
        int cycle = 0;
        while (cycle < 25 && count > 0) {
            this.verbose("Stage " + ++cycle);
            count = this.cyclicCleanDex();
            countTotal += count;
        }
        this.verbose("Cleaned dex: " + countTotal);
    }

    private int cyclicCleanDex() {
        int count = 0;
        UnusedFieldsCleaner fieldsCleaner = new UnusedFieldsCleaner(this.getBuildOption(), this.getApkModule(), this.getClassRepository());
        fieldsCleaner.setReporter(this.getReporter());
        fieldsCleaner.apply();
        count += fieldsCleaner.getCount();
        UnusedMethodsCleaner methodsCleaner = new UnusedMethodsCleaner(this.getBuildOption(), this.getApkModule(), this.getClassRepository());
        methodsCleaner.setReporter(this.getReporter());
        methodsCleaner.apply();
        count += methodsCleaner.getCount();
        UnusedAnnotationCleaner unusedAnnotationCleaner = new UnusedAnnotationCleaner(this.getBuildOption(), this.getApkModule(), this.getClassRepository());
        unusedAnnotationCleaner.setReporter(this.getReporter());
        unusedAnnotationCleaner.apply();
        count += unusedAnnotationCleaner.getCount();
        UnusedClassesCleaner classesCleaner = new UnusedClassesCleaner(this.getBuildOption(), this.getApkModule(), this.getClassRepository());
        classesCleaner.setReporter(this.getReporter());
        classesCleaner.setVitalClassesSet(this.vitalClassesSet);
        classesCleaner.apply();
        this.vitalClassesSet = classesCleaner.getVitalClassesSet();
        return count += classesCleaner.getCount();
    }

    private void resolveInlineIntegerFieldCalls() {
        if (this.getBuildOption().isMinifyResources()) {
            InlineFieldIntResolver resolver = new InlineFieldIntResolver(this.getClassRepository(), this.getApkModule().getTableBlock());
            resolver.setReporter(this.getReporter());
            resolver.apply();
        }
    }

    private void cleanUnusedResFiles() {
        if (!this.getBuildOption().isMinifyResources()) {
            return;
        }
        ApkModule apkModule = this.getApkModule();
        RequiredEntriesScanner scanner = new RequiredEntriesScanner(this.getBuildOption(), apkModule, this.getClassRepository());
        scanner.apply();
        Set<String> requiredFiles = scanner.getRequiredFiles();
        List<ResFile> resFileList = apkModule.listResFiles();
        ZipEntryMap zipEntryMap = apkModule.getZipEntryMap();
        for (ResFile resFile : resFileList) {
            String path = resFile.getFilePath();
            if (requiredFiles.contains(path)) continue;
            zipEntryMap.remove(path);
        }
    }

    private void removeResFiles() {
        if (!this.getBuildOption().isMinifyResources()) {
            return;
        }
        ApkModule apkModule = this.getApkModule();
        List<ResFile> resFileList = apkModule.listResFiles();
        ZipEntryMap zipEntryMap = apkModule.getZipEntryMap();
        for (ResFile resFile : resFileList) {
            zipEntryMap.remove(resFile.getInputSource());
        }
    }

    private void initializeRequiredIds() {
        ResourceMergeOption resourceMergeOption = this.getBuildOption().getResourceMergeOption();
        if (!this.getBuildOption().isMinifyResources()) {
            resourceMergeOption.setKeepEntries(CollectionUtil.getAcceptAll());
            return;
        }
        RequiredEntriesScanner scanner = new RequiredEntriesScanner(this.getBuildOption(), this.getApkModule(), this.getClassRepository());
        scanner.setReporter(this.getReporter());
        scanner.apply();
        Set<ResourceName> requiredResources = scanner.getRequiredResources();
        resourceMergeOption.setKeepEntries(resourceEntry -> requiredResources.contains(resourceEntry.toResourceName()));
    }

    public ApkBuildOption getBuildOption() {
        ApkBuildOption buildOption = this.buildOption;
        if (buildOption == null) {
            this.buildOption = buildOption = new ApkBuildOption();
        }
        return buildOption;
    }

    public void setBuildOption(ApkBuildOption buildOption) {
        this.buildOption = buildOption;
    }
}

