/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.graph.BaseDexClassProcessor;
import java.util.Iterator;
import java.util.function.Predicate;

public class InlineFieldIntResolver
extends BaseDexClassProcessor {
    private final Predicate<Integer> resourceIdChecker;
    private int mResolvedCount;

    public InlineFieldIntResolver(DexClassRepository classRepository, Predicate<Integer> resourceIdChecker) {
        super(classRepository);
        this.resourceIdChecker = resourceIdChecker;
    }

    public InlineFieldIntResolver(DexClassRepository classRepository, TableBlock tableBlock) {
        this(classRepository, InlineFieldIntResolver.createChecker(tableBlock));
    }

    public InlineFieldIntResolver(DexClassRepository classRepository) {
        this(classRepository, InlineFieldIntResolver.createDefaultChecker());
    }

    @Override
    public void apply() {
        this.verbose("Resolving inline resource ids ..");
        this.reset();
        Iterator<DexClass> iterator = this.getClassRepository().getDexClasses();
        while (iterator.hasNext()) {
            this.scanClass(iterator.next());
        }
        this.verbose("Resolved ids count: " + this.getResolvedCount());
    }

    public int getResolvedCount() {
        return this.mResolvedCount;
    }

    private void scanClass(DexClass dexClass) {
        Iterator<DexMethod> iterator = dexClass.getDeclaredMethods();
        while (iterator.hasNext()) {
            this.scanMethod(iterator.next());
        }
    }

    private void scanMethod(DexMethod dexMethod) {
        Iterator<DexInstruction> iterator = dexMethod.getInstructions();
        while (iterator.hasNext()) {
            DexInstruction instruction = iterator.next();
            Key value = this.getValueFromStaticField(instruction);
            if (value == null) continue;
            this.resolve(instruction, value);
        }
    }

    private Key getValueFromStaticField(DexInstruction instruction) {
        if (!instruction.is(Opcode.SGET)) {
            return null;
        }
        FieldKey fieldKey = (FieldKey)instruction.getKey();
        if (!TypeKey.TYPE_I.equals(fieldKey.getType())) {
            return null;
        }
        DexField dexField = (DexField)instruction.findDeclaration();
        if (dexField == null) {
            return null;
        }
        return dexField.getStaticValue();
    }

    private void resolve(DexInstruction instruction, Key value) {
        if (!(value instanceof PrimitiveKey)) {
            return;
        }
        if (!((PrimitiveKey)value).isInteger()) {
            return;
        }
        int id = ((PrimitiveKey.IntegerKey)value).value();
        if (!this.resourceIdChecker.test(id)) {
            return;
        }
        Key key = instruction.getKey();
        int register = instruction.getRegister();
        DexInstruction replace = instruction.replace(Opcode.CONST);
        replace.setRegister(register);
        replace.setAsInteger(id);
        ++this.mResolvedCount;
        if (this.isDebugEnabled()) {
            this.debug(key + " WITH " + replace.toString());
        }
    }

    private void reset() {
        this.mResolvedCount = 0;
    }

    private static Predicate<Integer> createChecker(TableBlock tableBlock) {
        return id -> {
            int i = id;
            return PackageBlock.isResourceId(i) && tableBlock.getResource(i) != null;
        };
    }

    private static Predicate<Integer> createDefaultChecker() {
        return PackageBlock::isResourceId;
    }
}

