/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.model.ResourceName;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.Value;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.BaseApkModuleProcessor;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class RequiredEntriesScanner
extends BaseApkModuleProcessor {
    private final ApkBuildOption buildOption;
    private final Set<ResourceName> requiredResources;
    private final Set<String> requiredFiles;
    private final Set<String> processedFiles;
    private final Set<Integer> processedNumbers;

    public RequiredEntriesScanner(ApkBuildOption buildOption, ApkModule apkModule, DexClassRepository classRepository) {
        super(apkModule, classRepository);
        this.buildOption = buildOption;
        this.requiredResources = new HashSet<ResourceName>();
        this.requiredFiles = new HashSet<String>();
        this.processedFiles = new HashSet<String>();
        this.processedNumbers = new HashSet<Integer>();
    }

    @Override
    public void apply() {
        this.scanUserConfigs();
        this.scanIdOnXml(this.getApkModule().getAndroidManifest());
        this.scanIdOnDexClasses();
        this.reset();
    }

    public Set<ResourceName> getRequiredResources() {
        return this.requiredResources;
    }

    public Set<String> getRequiredFiles() {
        return this.requiredFiles;
    }

    private void scanUserConfigs() {
        Predicate<? super ResourceName> filter = this.buildOption.getResourceMergeOption().getKeepResourceName();
        if (filter == null) {
            return;
        }
        Iterator<ResourceEntry> iterator = FilterIterator.of(this.getTableBlock().getResources(), resourceEntry -> {
            ResourceName resourceName = resourceEntry.toResourceName();
            return resourceName != null && filter.test(resourceName);
        });
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    private void scanIdOnResXml(String path) {
        if (path == null || !this.processedFiles.add(path)) {
            return;
        }
        ResFile resFile = this.getApkModule().getResFile(path);
        if (resFile != null) {
            this.requiredFiles.add(path);
            this.scanIdOnXml(resFile.getResXmlDocument());
        }
    }

    private void scanIdOnXml(ResXmlDocument resXmlDocument) {
        if (resXmlDocument != null) {
            Iterator iterator = resXmlDocument.recursiveAttributes();
            while (iterator.hasNext()) {
                this.addAttribute((AttributeValue)iterator.next());
            }
        }
    }

    private void scanIdOnDexClasses() {
        Iterator<ResourceEntry> iterator = ComputeIterator.of(this.getClassRepository().visitIntegers(), reference -> this.getLocalResource(reference.get()));
        while (iterator.hasNext()) {
            ResourceEntry resourceEntry = iterator.next();
            this.add(resourceEntry);
        }
    }

    private void add(ResourceEntry resourceEntry) {
        if (resourceEntry == null || !resourceEntry.isContext(this.getTableBlock())) {
            return;
        }
        ResourceName resourceName = resourceEntry.toResourceName();
        if (resourceName == null || !this.requiredResources.add(resourceName)) {
            return;
        }
        Iterator<Entry> iterator = resourceEntry.iterator(true);
        while (iterator.hasNext()) {
            this.addEntry(iterator.next());
        }
    }

    private void addEntry(Entry entry) {
        if (entry == null || entry.isNull()) {
            return;
        }
        if (entry.isScalar()) {
            this.addValue(entry.getResValue());
        } else if (entry.isComplex()) {
            this.addComplex(entry.getResTableMapEntry());
        }
    }

    private void addComplex(ResTableMapEntry mapEntry) {
        if (mapEntry == null) {
            return;
        }
        this.add(this.getLocalResource(mapEntry.getParentId()));
        for (ResValueMap valueMap : mapEntry) {
            this.addAttribute(valueMap);
        }
    }

    private void addAttribute(AttributeValue attribute) {
        if (attribute == null) {
            return;
        }
        this.add(attribute.resolveName());
        this.addValue(attribute);
    }

    private void addValue(Value value) {
        if (value == null) {
            return;
        }
        String path = value.getValueAsString();
        if (path != null) {
            this.scanIdOnResXml(path);
        } else {
            this.add(value.getValueAsReference());
        }
    }

    ResourceEntry getLocalResource(int id) {
        TableBlock tableBlock;
        ResourceEntry resourceEntry;
        if (PackageBlock.isResourceId(id) && this.processedNumbers.add(id) && (resourceEntry = (tableBlock = this.getTableBlock()).getLocalResource(id)) != null && resourceEntry.isContext(tableBlock)) {
            return resourceEntry;
        }
        return null;
    }

    private TableBlock getTableBlock() {
        return this.getApkModule().getTableBlock();
    }

    public void reset() {
        this.processedFiles.clear();
        this.processedNumbers.clear();
    }
}

