/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph.cleaners;

import com.reandroid.apk.ApkModule;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.program.ClassProgram;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.cleaners.UnusedCleaner;
import com.reandroid.utils.collection.FilterIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UnusedAnnotationCleaner
extends UnusedCleaner<DexClass> {
    public UnusedAnnotationCleaner(ApkBuildOption buildOption, ApkModule apkModule, DexClassRepository classRepository) {
        super(buildOption, apkModule, classRepository);
    }

    @Override
    public void apply() {
        if (!this.isEnabled()) {
            this.debug("Skip");
            return;
        }
        Set<TypeKey> unusedAnnotations = this.findUnusedAnnotations();
        this.cleanAnnotations(unusedAnnotations);
    }

    private void cleanAnnotations(Set<TypeKey> unusedAnnotations) {
        DexClassRepository repository = this.getClassRepository();
        for (TypeKey typeKey : unusedAnnotations) {
            if (!repository.removeAnnotations(typeKey)) continue;
            this.addCount();
        }
    }

    private Set<TypeKey> findUnusedAnnotations() {
        this.verbose("Searching ...");
        HashSet<TypeKey> targetAnnotations = new HashSet<TypeKey>();
        Iterator<DexClass> iterator = this.getTargetAnnotations();
        while (iterator.hasNext()) {
            targetAnnotations.add(iterator.next().getKey());
        }
        this.subtractUnused(targetAnnotations);
        this.logUnused(targetAnnotations);
        this.verbose("Unused annotations: " + targetAnnotations.size());
        return targetAnnotations;
    }

    private void logUnused(Set<TypeKey> unusedAnnotations) {
        if (this.isDebugEnabled()) {
            for (TypeKey typeKey : unusedAnnotations) {
                this.debug(typeKey.getTypeName());
            }
        }
    }

    private void subtractUnused(Set<TypeKey> targetAnnotations) {
        Iterator<DexClass> iterator = this.getClassRepository().getDexClasses();
        while (!targetAnnotations.isEmpty() && iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            Iterator<DexInstruction> instructions = dexClass.getDexInstructions();
            while (instructions.hasNext()) {
                this.subtractUnused(targetAnnotations, instructions.next());
            }
        }
    }

    private void subtractUnused(Set<TypeKey> targetAnnotations, DexInstruction userInstruction) {
        Key key = userInstruction.getKey();
        if (key != null) {
            Iterator<? extends Key> iterator = key.mentionedKeys();
            while (iterator.hasNext()) {
                TypeKey typeKey = iterator.next().getDeclaring();
                targetAnnotations.remove(typeKey);
            }
        }
    }

    private Iterator<DexClass> getTargetAnnotations() {
        return FilterIterator.of(this.getClassRepository().getDexClasses(), ClassProgram::isAnnotation);
    }

    @Override
    protected boolean isEnabled() {
        return this.getBuildOption().isCleanAnnotations();
    }
}

