/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.graph.cleaners;

import com.reandroid.apk.ApkModule;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.Dex;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.graph.ApkBuildOption;
import com.reandroid.graph.cleaners.UnusedCleaner;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public abstract class UnusedClassComponentCleaner<T extends Dex>
extends UnusedCleaner<T> {
    public UnusedClassComponentCleaner(ApkBuildOption buildOption, ApkModule apkModule, DexClassRepository classRepository) {
        super(buildOption, apkModule, classRepository);
    }

    @Override
    public void apply() {
        if (!this.isEnabled()) {
            this.debug("Skip");
            return;
        }
        this.verbose("Searching for unused ...");
        this.cleanUnusedInCleanableClasses();
        this.verbose("Cleaned: " + this.getCount());
    }

    protected abstract List<T> listUnusedInClass(DexClass var1);

    protected void cleanUnusedInCleanableClasses() {
        Iterator<DexClass> iterator = this.getCleanableClasses();
        while (iterator.hasNext()) {
            this.cleanUnusedInClass(iterator.next());
        }
    }

    protected void cleanUnusedInClass(DexClass dexClass) {
        List<T> unusedList = this.listUnusedInClass(dexClass);
        if (unusedList != null) {
            boolean debugEnabled = this.isDebugEnabled();
            for (Dex item : unusedList) {
                if (debugEnabled) {
                    this.debug(this.getDebugString(item));
                }
                item.removeSelf();
                this.addCount();
            }
        }
    }

    protected Iterator<DexClass> getCleanableClasses() {
        return this.getDexClasses(this::isCleanableClass);
    }

    protected boolean isCleanableClass(DexClass dexClass) {
        if (dexClass.usesNative() || dexClass.isEnum()) {
            return false;
        }
        Predicate<? super TypeKey> filter = this.getBuildOption().getKeepClasses();
        return filter == null || !filter.test(dexClass.getKey());
    }

    protected String getDebugString(T item) {
        if (item instanceof DexDeclaration) {
            return ((DexDeclaration)item).getKey().toString();
        }
        return ((Dex)item).toSmaliString();
    }
}

