/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.jcommand;

import com.reandroid.jcommand.CommandStringResource;
import com.reandroid.jcommand.CommandStrings;
import com.reandroid.jcommand.utils.SpreadSheet;
import com.reandroid.jcommand.utils.TwoColumnTable;
import java.util.HashMap;

public abstract class HelpBuilder {
    private final CommandStringResource stringResource;
    private final TwoColumnTable twoColumnTable;
    private String[] footers;

    public HelpBuilder(CommandStringResource stringResource) {
        if (stringResource == null) {
            stringResource = HelpBuilder.defaultStringResource();
        }
        this.stringResource = stringResource;
        this.twoColumnTable = new TwoColumnTable();
    }

    public void setMaxWidth(int maxWidth) {
        this.getTable().setMaxWidth(maxWidth);
    }

    public void setTab2(String tab2) {
        this.getTable().setTab2(tab2);
    }

    public void setColumnSeparator(String columnSeparator) {
        this.getTable().setColumnSeparator(columnSeparator);
    }

    public void setDrawBorder(boolean headerSeparators) {
        this.getTable().setDrawBorder(headerSeparators);
    }

    public String[] getFooters() {
        return this.footers;
    }

    public void setFooters(String ... footers) {
        this.footers = footers;
    }

    public String build() {
        return this.buildTable().toString();
    }

    public abstract SpreadSheet buildTable();

    public void appendLines(boolean tabbed, String[] headings) {
        if (headings == null || headings.length == 0) {
            return;
        }
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        for (String heading : headings) {
            heading = stringResource.getString(heading);
            if (tabbed) {
                twoColumnTable.addMergedRowTabbed(heading);
                continue;
            }
            twoColumnTable.addMergedRow(heading);
        }
        twoColumnTable.addSeparator();
    }

    protected void appendFooters() {
        String[] footers = this.getFooters();
        if (footers == null || footers.length == 0) {
            return;
        }
        CommandStringResource stringResource = this.getStringResource();
        TwoColumnTable twoColumnTable = this.getTable();
        twoColumnTable.addSeparator();
        for (String footer : footers) {
            twoColumnTable.addMergedRow(stringResource.getString(footer)).setHorizontalIndent(0);
        }
    }

    public TwoColumnTable getTable() {
        return this.twoColumnTable;
    }

    public CommandStringResource getStringResource() {
        return this.stringResource;
    }

    public void reset() {
        this.getTable().clear();
    }

    public static CommandStringResource defaultStringResource() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CommandStrings.title_commands, "Commands:");
        map.put(CommandStrings.title_options, "Options:");
        map.put(CommandStrings.title_flags, "Flags:");
        map.put(CommandStrings.title_usage, "Usage:");
        map.put(CommandStrings.title_example, "Examples:");
        map.put(CommandStrings.title_notes, "Notes:");
        return resourceName -> {
            String str = (String)map.get(resourceName);
            if (str == null) {
                str = resourceName;
            }
            return str;
        };
    }
}

