/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

public abstract class ByteDigest {
    private byte[] oneByte;

    public void update(byte data) {
        byte[] oneByte = this.oneByte;
        if (oneByte == null) {
            this.oneByte = oneByte = new byte[1];
        }
        oneByte[0] = data;
        this.update(oneByte, 0, 1);
    }

    public void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract int getDigestLength();

    public byte[] digest() {
        byte[] out = new byte[this.getDigestLength()];
        this.digest(out, 0);
        return out;
    }

    public abstract void digest(byte[] var1, int var2);

    public abstract void reset();

    static int getBigEndianInteger(byte[] bytes, int offset) {
        return bytes[offset + 3] & 0xFF | (bytes[offset + 2] & 0xFF) << 8 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset] & 0xFF) << 24;
    }

    static void putBigEndianInteger(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)(value >>> 24);
        bytes[offset + 1] = (byte)(value >>> 16);
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 3] = (byte)(value & 0xFF);
    }

    static void fillZero(int[] arr) {
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = 0;
        }
    }

    static void fillZero(byte[] arr) {
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            arr[i] = 0;
        }
    }
}

