/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class HexBytesWriter {
    private final byte[] byteArray;
    private final int width;
    private final int columns;
    private final int indent;
    private boolean mAppendString = true;
    private String mEncoding;
    private int lineNumber;
    private boolean showLineNumber;
    private boolean decimalLineNumber;
    private String lineNumberFormat;
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_COLUMNS = 4;
    private static final int DEFAULT_INDENT = 0;

    public HexBytesWriter(byte[] byteArray, int width, int columns, int indent) {
        this.byteArray = byteArray;
        this.width = width <= 0 ? 16 : width;
        this.columns = columns <= 0 ? width : columns;
        this.indent = indent;
    }

    public HexBytesWriter(byte[] byteArray, int width) {
        this(byteArray, width, 4, 0);
    }

    public HexBytesWriter(byte[] byteArray) {
        this(byteArray, 16, 4, 0);
    }

    public void setShowLineNumber(boolean showLineNumber) {
        this.showLineNumber = showLineNumber;
    }

    public void setDecimalLineNumber(boolean decimalLineNumber) {
        this.decimalLineNumber = decimalLineNumber;
    }

    public void setAppendString(boolean appendString) {
        this.mAppendString = appendString;
    }

    public void setEncoding(String encoding) {
        if (!"UTF-16".equals(encoding)) {
            encoding = "UTF-8";
        }
        this.mEncoding = encoding;
    }

    private String getEncoding() {
        if (this.mEncoding == null) {
            this.mEncoding = "UTF-8";
        }
        return this.mEncoding;
    }

    public void write(Writer writer) throws IOException {
        if (this.byteArray == null) {
            return;
        }
        this.write(writer, 0, this.byteArray.length);
    }

    public void write(Writer writer, int offset, int length) throws IOException {
        byte[] byteArray = this.byteArray;
        if (byteArray == null) {
            return;
        }
        this.initLineNumber(byteArray.length);
        int width = this.width;
        int columns = this.columns;
        int x = 0;
        boolean newLineAppended = false;
        for (int i = 0; i < length; ++i) {
            if (i % width == 0) {
                if (i != 0) {
                    this.writeString(writer, x, i);
                    this.writeNewLine(writer);
                    newLineAppended = true;
                }
                this.writeIndent(writer);
                this.writeLineNumber(writer);
                x = 0;
            } else if (x % columns == 0) {
                writer.write(32);
            }
            if (!newLineAppended && i != 0) {
                writer.write(32);
            }
            ++x;
            newLineAppended = false;
            this.writeHex(writer, byteArray[offset + i]);
        }
        if (x > 0) {
            this.writeString(writer, x, length);
        }
    }

    private void writeHex(Writer writer, byte b) throws IOException {
        String hex = HexUtil.toHex(null, 0xFF & b, 2).toUpperCase();
        writer.write(hex);
    }

    private void writeString(Writer writer, int width, int position) throws IOException {
        int rem;
        if (!this.mAppendString) {
            return;
        }
        int start = position - width;
        if (start < 0) {
            start = 0;
        }
        if ((rem = this.width - width) > 0) {
            this.fillLastRow(writer, position);
        }
        writer.write(32);
        writer.write(32);
        writer.write(32);
        writer.write(32);
        String text = new String(this.byteArray, start, width, this.getEncoding());
        for (char ch : text.toCharArray()) {
            this.printChar(writer, ch);
        }
    }

    private void fillLastRow(Writer writer, int position) throws IOException {
        int rem = this.width - position % this.width;
        for (int i = 0; i < rem; ++i) {
            if (i != 0 && i % this.columns == 0) {
                writer.write(32);
            }
            writer.write(32);
            writer.write(32);
            writer.write(32);
        }
        if (rem % this.columns == 0) {
            writer.write(32);
        }
    }

    private void printChar(Writer writer, char ch) throws IOException {
        switch (ch) {
            case '\n': {
                writer.write(92);
                writer.write(110);
                break;
            }
            case '\r': {
                writer.write(92);
                writer.write(114);
                break;
            }
            case '\t': {
                writer.write(92);
                writer.write(116);
                break;
            }
            default: {
                writer.write(ch);
            }
        }
    }

    private void writeIndent(Writer writer) throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            writer.write(32);
        }
    }

    private void writeLineNumber(Writer writer) throws IOException {
        if (!this.showLineNumber) {
            return;
        }
        String line = String.format(this.lineNumberFormat, this.lineNumber);
        if (!this.decimalLineNumber) {
            line = line.toUpperCase();
        }
        writer.write(line);
        writer.write(": ");
        this.lineNumber += this.width;
    }

    private void initLineNumber(int max) {
        this.lineNumber = 0;
        int base = this.decimalLineNumber ? 10 : 16;
        int digits = 1;
        while (max > base) {
            ++digits;
            max /= base;
        }
        this.lineNumberFormat = "%0" + digits + (this.decimalLineNumber ? "d" : "x");
    }

    private void writeNewLine(Writer writer) throws IOException {
        writer.write(10);
    }

    public static String printHex(byte[] byteArray) {
        return HexBytesWriter.toHex(byteArray, false, false);
    }

    public static String toHex(byte[] byteArray) {
        if (byteArray == null) {
            return "null";
        }
        return HexBytesWriter.toHex(byteArray, byteArray.length > 64);
    }

    public static String toHex(byte[] byteArray, boolean showLineNumber) {
        return HexBytesWriter.toHex(byteArray, showLineNumber, true);
    }

    public static String toHex(byte[] byteArray, boolean showLineNumber, boolean appendString) {
        if (byteArray == null) {
            return "null";
        }
        StringWriter writer = new StringWriter();
        HexBytesWriter hexBytesWriter = new HexBytesWriter(byteArray);
        hexBytesWriter.setShowLineNumber(showLineNumber);
        hexBytesWriter.setAppendString(appendString);
        try {
            hexBytesWriter.write(writer);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }
}

