/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

public class Nibble
extends Number {
    public static final byte MIN_VALUE = -8;
    public static final byte MAX_VALUE = 7;
    public static final int SIZE = 4;
    public static final int BYTES = 1;
    private static final Nibble[] VALUES;
    private final int value;

    public Nibble(int value) {
        if (value < -8 || value > 7) {
            throw new NumberFormatException("Nibble value out of range: " + value);
        }
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Number)) {
            return false;
        }
        Number number = (Number)obj;
        return this.value == number.intValue();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public static int toSigned(int unsignedNibble) {
        if (unsignedNibble < 8) {
            return unsignedNibble;
        }
        return unsignedNibble - 16;
    }

    public static int toUnsigned(int signedNibble) {
        if (signedNibble >= 0) {
            return signedNibble;
        }
        return 16 + signedNibble;
    }

    public static Nibble valueOf(int nibble) {
        return VALUES[nibble + 8];
    }

    static {
        int length = 16;
        Nibble[] values = new Nibble[16];
        VALUES = values;
        for (int i = 0; i < length; ++i) {
            values[i] = new Nibble(i - 8);
        }
    }
}

