/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class ComputeIterator<E, T>
implements Iterator<T> {
    private final Iterator<? extends E> iterator;
    private final Function<? super E, T> function;
    private final Predicate<T> filter;
    private T mNext;

    public ComputeIterator(Iterator<? extends E> iterator, Function<? super E, T> function, Predicate<T> filter) {
        this.iterator = iterator;
        this.function = function;
        this.filter = filter;
    }

    public ComputeIterator(Iterator<? extends E> iterator, Function<? super E, T> function) {
        this(iterator, function, null);
    }

    @Override
    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public T next() {
        T item = this.getNext();
        if (item == null) {
            throw new NoSuchElementException();
        }
        this.mNext = null;
        return item;
    }

    private T getNext() {
        if (this.mNext == null) {
            while (this.iterator.hasNext()) {
                T output = this.function.apply(this.iterator.next());
                if (output == null || this.filter != null && !this.filter.test(output)) continue;
                this.mNext = output;
                break;
            }
        }
        return this.mNext;
    }

    public static <E1, T1> Iterator<T1> of(Iterator<? extends E1> iterator, Function<? super E1, T1> function) {
        if (!iterator.hasNext()) {
            return EmptyIterator.of();
        }
        return new ComputeIterator<E1, T1>(iterator, function);
    }
}

