/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SizedSupplier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class IndexIterator<T>
implements Iterator<T> {
    private final Predicate<? super T> mFilter;
    private final SizedSupplier<? extends T> mSupplier;
    private int mIndex;
    private T mNext;

    public IndexIterator(SizedSupplier<? extends T> supplier, Predicate<? super T> filter) {
        this.mSupplier = supplier;
        this.mFilter = filter;
    }

    public IndexIterator(SizedSupplier<? extends T> supplier) {
        this(supplier, null);
    }

    @Override
    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public T next() {
        T item = this.getNext();
        if (item == null) {
            throw new NoSuchElementException();
        }
        this.mNext = null;
        return item;
    }

    private T getNext() {
        if (this.mNext == null) {
            while (this.mIndex < this.mSupplier.size()) {
                T item = this.mSupplier.get(this.mIndex);
                ++this.mIndex;
                if (!this.testAll(item)) continue;
                this.mNext = item;
                break;
            }
        }
        return this.mNext;
    }

    private boolean testAll(T item) {
        if (item == null) {
            return false;
        }
        return this.mFilter == null || this.mFilter.test(item);
    }

    public static <T1> Iterator<T1> of(SizedSupplier<T1> supplier) {
        return IndexIterator.of(supplier, null);
    }

    public static <T1> Iterator<T1> of(SizedSupplier<T1> supplier, Predicate<? super T1> filter) {
        if (supplier == null || supplier.size() == 0) {
            return EmptyIterator.of();
        }
        return new IndexIterator<T1>(supplier, filter);
    }
}

