/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class IterableIterator<E, T>
implements Iterator<T> {
    private final Iterator<? extends E> iterator;
    private Iterator<T> mCurrent;
    private int mCount;
    private boolean mStop;

    public IterableIterator(Iterator<? extends E> iterator) {
        this.iterator = iterator;
    }

    public int getCountValue() {
        return this.mCount;
    }

    public void stop() {
        this.mStop = true;
    }

    public abstract Iterator<T> iterator(E var1);

    @Override
    public boolean hasNext() {
        Iterator<T> current = this.getCurrent();
        return current != null && !this.mStop && current.hasNext();
    }

    @Override
    public T next() {
        Iterator<T> current = this.getCurrent();
        if (current == null) {
            throw new NoSuchElementException();
        }
        T item = current.next();
        ++this.mCount;
        return item;
    }

    private Iterator<T> getCurrent() {
        if (this.mCurrent == null || !this.mCurrent.hasNext()) {
            this.mCurrent = null;
            while (this.iterator.hasNext()) {
                Iterator<T> item = this.iterator(this.iterator.next());
                if (item == null || !item.hasNext()) continue;
                this.mCurrent = item;
                break;
            }
        }
        return this.mCurrent;
    }
}

