/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class MultiMap<K, V> {
    private final Object mLock = new Object();
    private Map<K, Object> map;
    private int initialSize;
    private Comparator<? super V> favouriteObjectsSorter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findDuplicates(Comparator<? super V> comparator, Consumer<List<V>> consumer) {
        Object object = this.mLock;
        synchronized (object) {
            Map<K, Object> map = this.map;
            if (map == null || map.isEmpty()) {
                return;
            }
            Set<Map.Entry<K, Object>> entrySet = map.entrySet();
            for (Map.Entry<K, Object> entry : entrySet) {
                Object obj = entry.getValue();
                if (obj == null || obj.getClass() != EntryList.class) continue;
                EntryList entryList = (EntryList)obj;
                if (entryList.size() == 1) {
                    entry.setValue(entryList.get(0));
                    continue;
                }
                this.processDuplicateValues(comparator, consumer, entryList);
            }
        }
    }

    private void processDuplicateValues(Comparator<? super V> comparator, Consumer<List<V>> consumer, EntryList<V> entryList) {
        Object previous;
        int size = entryList.size();
        if (size < 2) {
            return;
        }
        ArrayCollection<Object> sortedList = new ArrayCollection<Object>(entryList);
        size = sortedList.size();
        if (!this.sortFavourites(sortedList)) {
            sortedList.sort((Comparator<Object>)comparator);
        }
        if (comparator.compare(previous = sortedList.get(0), sortedList.get(size - 1)) == 0) {
            consumer.accept(sortedList);
            return;
        }
        ArrayCollection<Object> result = new ArrayCollection<Object>(size);
        result.add(previous);
        for (int i = 1; i < size; ++i) {
            Object value = sortedList.get(i);
            int compare = comparator.compare(previous, value);
            if (compare != 0) {
                if (result.size() > 1) {
                    consumer.accept(result);
                }
                result.clearTemporarily();
            }
            result.add(value);
            previous = value;
        }
        if (result.size() > 1) {
            consumer.accept(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Function<? super V, K> function, Iterator<? extends V> iterator) {
        Object object = this.mLock;
        synchronized (object) {
            while (iterator.hasNext()) {
                V value = iterator.next();
                this.putUnlocked(function.apply(value), value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        Object object = this.mLock;
        synchronized (object) {
            return this.map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Object object = this.mLock;
        synchronized (object) {
            this.putUnlocked(key, value);
        }
    }

    private void putUnlocked(K key, V value) {
        if (key == null || value == null) {
            return;
        }
        Map<K, Object> map = this.getInitializedMap();
        Object obj = map.get(key);
        if (obj == null) {
            map.put(key, value);
            return;
        }
        if (obj.getClass() == EntryList.class) {
            EntryList entryList = (EntryList)obj;
            if (!entryList.containsExact(value)) {
                entryList.add(value);
                this.sortFavourites(entryList);
            }
        } else {
            obj = map.remove(key);
            obj = this.combine(obj, value);
            map.put(key, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key, Object value) {
        Object object = this.mLock;
        synchronized (object) {
            if (key == null) {
                return null;
            }
            Map<Object, Object> map = this.map;
            if (map == null) {
                return null;
            }
            Object obj = map.get(key);
            if (obj == null) {
                return null;
            }
            if (obj.getClass() == EntryList.class) {
                EntryList entryList = (EntryList)obj;
                int i = entryList.indexOfExact(value);
                if (i < 0) {
                    return null;
                }
                obj = entryList.remove(i);
                if (entryList.isEmpty()) {
                    map.remove(key);
                } else if (entryList.size() == 1) {
                    obj = entryList.get(0);
                    map.remove(key);
                    map.put(key, obj);
                }
                return (V)obj;
            }
            if (obj == value) {
                return (V)map.remove(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        Object object = this.mLock;
        synchronized (object) {
            if (key == null) {
                return null;
            }
            Map<K, Object> map = this.map;
            if (map == null) {
                return null;
            }
            return (V)map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V removeIf(Object key, Predicate<? super V> predicate) {
        Object object = this.mLock;
        synchronized (object) {
            if (key == null) {
                return null;
            }
            Map<Object, Object> map = this.map;
            if (map == null) {
                return null;
            }
            Object obj = map.get(key);
            if (obj == null) {
                return null;
            }
            if (obj.getClass() == EntryList.class) {
                EntryList entryList = (EntryList)obj;
                int i = entryList.indexOfIf(predicate);
                if (i < 0) {
                    return null;
                }
                obj = entryList.remove(i);
                if (entryList.isEmpty()) {
                    map.remove(key);
                } else if (entryList.size() == 1) {
                    obj = entryList.get(0);
                    map.remove(key);
                    map.put(key, obj);
                }
                return (V)obj;
            }
            if (predicate.test(obj)) {
                return (V)map.remove(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object object = this.mLock;
        synchronized (object) {
            if (key == null) {
                return false;
            }
            Map<K, Object> map = this.map;
            if (map == null) {
                return false;
            }
            return map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object key, Predicate<? super V> predicate) {
        Object object = this.mLock;
        synchronized (object) {
            if (key == null) {
                return false;
            }
            Map<K, Object> map = this.map;
            if (map == null) {
                return false;
            }
            Object obj = map.get(key);
            if (obj == null) {
                return false;
            }
            if (obj.getClass() == EntryList.class) {
                EntryList entryList = (EntryList)obj;
                return entryList.containsIf(predicate);
            }
            return predicate.test(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateKey(K old, K key, V value) {
        Object object = this.mLock;
        synchronized (object) {
            if (old == null && key == null) {
                return false;
            }
            Map<K, Object> map = this.getInitializedMap();
            Object obj = this.combine(map.remove(old), map.remove(key));
            obj = this.combine(obj, value);
            map.put(key, obj);
            return true;
        }
    }

    private Object combine(Object obj1, Object obj2) {
        boolean list2;
        if (obj1 == obj2) {
            return obj1;
        }
        if (obj1 == null) {
            return obj2;
        }
        if (obj2 == null) {
            return obj1;
        }
        boolean list1 = obj1.getClass() == EntryList.class;
        boolean bl = list2 = obj2.getClass() == EntryList.class;
        if (!list1 && !list2) {
            EntryList<Object> entryList = new EntryList<Object>(obj1, obj2);
            this.sortFavourites(entryList);
            return entryList;
        }
        if (list1 && !list2) {
            EntryList entryList = (EntryList)obj1;
            if (!entryList.containsExact(obj2)) {
                entryList.add(obj2);
                this.sortFavourites(entryList);
            }
            return entryList;
        }
        if (!list1) {
            EntryList entryList = (EntryList)obj2;
            if (!entryList.containsExact(obj1)) {
                entryList.add(obj1);
                this.sortFavourites(entryList);
            }
            return entryList;
        }
        EntryList entryList1 = (EntryList)obj1;
        EntryList entryList2 = (EntryList)obj2;
        boolean added = false;
        for (Object obj : entryList2) {
            if (entryList1.containsExact(obj)) continue;
            entryList1.add(obj);
            added = true;
        }
        if (added) {
            this.sortFavourites(entryList1);
        }
        return entryList1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<V> getAll(K key) {
        Object object = this.mLock;
        synchronized (object) {
            if (key == null) {
                return EmptyIterator.of();
            }
            Map<K, Object> map = this.map;
            if (map == null) {
                return EmptyIterator.of();
            }
            Object obj = map.get(key);
            if (obj == null) {
                return EmptyIterator.of();
            }
            if (obj.getClass() == EntryList.class) {
                return ((EntryList)obj).iterator();
            }
            return SingleIterator.of(obj);
        }
    }

    public V get(K key) {
        return this.get(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Predicate<? super V> predicate) {
        Object object = this.mLock;
        synchronized (object) {
            if (key == null) {
                return null;
            }
            Map<K, Object> map = this.map;
            if (map == null) {
                return null;
            }
            Object obj = map.get(key);
            if (obj == null) {
                return null;
            }
            if (obj.getClass() == EntryList.class) {
                return this.getFromEntryList(key, (EntryList)obj, predicate);
            }
            Object value = obj;
            if (predicate != null && !predicate.test(value)) {
                value = null;
            }
            return (V)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            Map<K, Object> map = this.map;
            if (map != null) {
                if (this.initialSize == 0) {
                    this.initialSize = map.size();
                }
                this.map = null;
                map.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            Map<K, Object> map = this.map;
            if (map == null) {
                return 0;
            }
            return map.size();
        }
    }

    private Map<K, Object> getInitializedMap() {
        Map<K, Object> map = this.map;
        if (map == null) {
            int size = this.initialSize;
            map = size == 0 ? new HashMap<K, Object>() : new HashMap<K, Object>(size);
            this.map = map;
        }
        return map;
    }

    private boolean sortFavourites(List<Object> entryList) {
        Comparator<? super V> comparator = this.favouriteObjectsSorter;
        if (comparator == null) {
            return false;
        }
        if (entryList == null || entryList.size() < 2) {
            return false;
        }
        entryList.sort(comparator);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFavouriteObjectsSorter(Comparator<? super V> favouriteObjectsSorter) {
        Object object = this.mLock;
        synchronized (object) {
            this.favouriteObjectsSorter = favouriteObjectsSorter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialSize(int size) {
        Object object = this.mLock;
        synchronized (object) {
            this.initialSize = size;
            Map<K, Object> map = this.map;
            if (map != null && map.isEmpty()) {
                this.map = null;
            }
        }
    }

    private V getFromEntryList(K key, EntryList<?> entryList, Predicate<? super V> predicate) {
        if (entryList.isEmpty()) {
            this.map.remove(key);
            return null;
        }
        EntryList<?> list = entryList;
        if (predicate == null) {
            return (V)list.getFirst();
        }
        return CollectionUtil.getFirst(list.iterator(predicate));
    }

    public String toString() {
        return "size = " + this.size();
    }

    static class EntryList<T>
    extends ArrayCollection<T> {
        public EntryList(Object item1, Object item2) {
            super(new Object[]{item1, item2});
        }
    }
}

