/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;
import java.util.List;

public abstract class ReversedIterator<T>
implements Iterator<T> {
    private final int mEndIndex;
    private int index;
    private T mNext;

    public ReversedIterator(int start, int length) {
        int end = start - length;
        if (end < 0) {
            end = 0;
        }
        this.mEndIndex = end;
        this.index = start;
    }

    public abstract T get(int var1);

    @Override
    public boolean hasNext() {
        return this.computeNext() != null;
    }

    @Override
    public T next() {
        T item = this.computeNext();
        this.mNext = null;
        return item;
    }

    private T computeNext() {
        T next = this.mNext;
        while (next == null && this.index >= this.mEndIndex) {
            next = this.testAll(this.get(this.index));
            --this.index;
        }
        this.mNext = next;
        return next;
    }

    private T testAll(T item) {
        return item;
    }

    public static <T1> Iterator<T1> of(List<? extends T1> elements) {
        int size = elements.size();
        if (size == 0) {
            return EmptyIterator.of();
        }
        return ReversedIterator.of(elements, size - 1, size);
    }

    public static <T1> Iterator<T1> of(List<? extends T1> elements, int start) {
        return ReversedIterator.of(elements, start, start + 1);
    }

    public static <T1> Iterator<T1> of(final List<? extends T1> elements, int start, int length) {
        if (elements.isEmpty()) {
            return EmptyIterator.of();
        }
        return new ReversedIterator<T1>(start, length){

            @Override
            public T1 get(int i) {
                return elements.get(i);
            }
        };
    }

    public static <T1> Iterator<T1> of(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return EmptyIterator.of();
        }
        int size = elements.length;
        return ReversedIterator.of(elements, size - 1, size);
    }

    public static <T1> Iterator<T1> of(Object[] elements, int start) {
        return ReversedIterator.of(elements, start, start + 1);
    }

    public static <T1> Iterator<T1> of(final Object[] elements, int start, int length) {
        if (elements == null || elements.length == 0) {
            return EmptyIterator.of();
        }
        return new ReversedIterator<T1>(start, length){

            @Override
            public T1 get(int i) {
                return elements[i];
            }
        };
    }
}

