/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.SpanSet;
import com.reandroid.xml.StyleElement;
import com.reandroid.xml.StyleText;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StyleDocument
extends XMLDocument
implements SpanSet<StyleElement>,
Comparable<StyleDocument> {
    private static final XmlPullParser PARSER = XMLFactory.newPullParser();

    public boolean hasElements() {
        return this.getElements().hasNext();
    }

    public Iterator<StyleElement> getElements() {
        return this.iterator(StyleElement.class);
    }

    @Override
    public Iterator<StyleElement> getSpans() {
        return InstanceIterator.of(this.recursiveNodes(), StyleElement.class);
    }

    public Iterator<StyleText> getStyleTexts() {
        return InstanceIterator.of(this.recursiveNodes(), StyleText.class);
    }

    public String getXml() {
        return this.toText(true, false);
    }

    public String getXml(boolean escapeXmlText) {
        return this.toText(true, escapeXmlText);
    }

    public String getHtml() {
        return this.getText(false, false);
    }

    public String getText(boolean xml, boolean escapeXmlText) {
        return this.toText(xml, escapeXmlText);
    }

    public String getStyledString() {
        StringWriter writer = new StringWriter();
        try {
            this.writeStyledText(writer);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    void writeStyledText(Appendable appendable) throws IOException {
        for (XMLNode xmlNode : this) {
            if (xmlNode instanceof StyleText) {
                StyleText styleText = (StyleText)xmlNode;
                styleText.writeStyledText(appendable);
                continue;
            }
            if (!(xmlNode instanceof StyleElement)) continue;
            StyleElement element = (StyleElement)xmlNode;
            element.writeStyledText(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseString(String xmlString) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = PARSER;
        synchronized (xmlPullParser) {
            xmlString = "<parser>" + xmlString + "</parser>";
            XmlPullParser parser = PARSER;
            parser.setInput(new StringReader(xmlString));
            XMLUtil.setFeatureRelaxed(parser, true);
            XMLUtil.ensureStartTag(parser);
            parser.nextToken();
            this.parseInner(parser);
            IOUtil.close(parser);
        }
    }

    @Override
    public int compareTo(StyleDocument document) {
        if (document == null) {
            return 0;
        }
        return this.getStyledString().compareTo(document.getStyledString());
    }

    public int hashCode() {
        return this.getXml().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StyleDocument)) {
            return false;
        }
        return this.getXml().equals(((StyleDocument)obj).getXml());
    }

    @Override
    public StyleElement newElement() {
        StyleElement element = new StyleElement();
        this.add(element);
        return element;
    }

    @Override
    public StyleText newText() {
        StyleText styleText = new StyleText();
        this.add(styleText);
        return styleText;
    }

    @Override
    public StyleText newText(String text) {
        return (StyleText)super.newText(text);
    }

    @Override
    public XMLComment newComment() {
        throw new IllegalArgumentException("Can not create comment at style document: " + this.getClass());
    }

    public static StyleDocument parseNext(XmlPullParser parser) throws IOException, XmlPullParserException {
        StyleDocument styleDocument = new StyleDocument();
        styleDocument.parseInner(parser);
        return styleDocument;
    }

    public static StyleDocument copyInner(XMLElement xmlElement) {
        StyleDocument styleDocument = new StyleDocument();
        for (XMLNode xmlNode : xmlElement) {
            if (xmlNode instanceof XMLElement) {
                styleDocument.newElement().copyFrom((XMLElement)xmlNode);
                continue;
            }
            if (!(xmlNode instanceof XMLText)) continue;
            XMLText xmlText = (XMLText)xmlNode;
            styleDocument.newText(xmlText.getText());
        }
        return styleDocument;
    }

    public static StyleDocument parseStyledString(String xmlStyledString) throws XmlPullParserException, IOException {
        StyleDocument styleDocument = new StyleDocument();
        styleDocument.parseString(xmlStyledString);
        return styleDocument;
    }

    public static StyleDocument create(String xmlStyledString) {
        try {
            return StyleDocument.parseStyledString(xmlStyledString);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

