/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLDocDeclaration;
import com.reandroid.xml.XMLDocType;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import java.util.Iterator;

public class XMLDebugStringBuilder {
    private static final int STRING_LIMIT = 300;
    private static final int MAX_INDENT = 10;

    public static String build(XMLNode node) {
        StringBuilder indent = new StringBuilder();
        indent.append('\n');
        StringBuilder builder = new StringBuilder();
        XMLDebugStringBuilder.appendNode(indent, builder, node);
        return builder.toString();
    }

    private static void appendNode(StringBuilder indent, StringBuilder builder, XMLNode node) {
        if (XMLDebugStringBuilder.limitReached(builder)) {
            return;
        }
        if (node instanceof XMLDocument) {
            XMLDebugStringBuilder.appendDocument(indent, builder, (XMLDocument)node);
        } else if (node instanceof XMLElement) {
            XMLDebugStringBuilder.appendElement(indent, builder, (XMLElement)node);
        } else if (node instanceof XMLText) {
            XMLDebugStringBuilder.appendText(builder, (XMLText)node);
        } else if (node instanceof XMLDocType) {
            XMLDebugStringBuilder.appendDocDeclaration(builder, (XMLDocType)node);
        } else if (node != null) {
            builder.append(node);
        }
    }

    private static void appendDocument(StringBuilder indent, StringBuilder builder, XMLDocument document) {
        XMLDocDeclaration declaration;
        if (XMLDebugStringBuilder.limitReached(builder)) {
            return;
        }
        if (indent.length() > 1) {
            builder.append(XMLDebugStringBuilder.addIndent(indent));
        }
        if ((declaration = document.getDeclaration()).isValid()) {
            builder.append(declaration.toString());
        }
        boolean hasChildes = false;
        Iterator<XMLNode> iterator = document.iterator();
        while (iterator.hasNext() && !XMLDebugStringBuilder.limitReached(builder)) {
            XMLDebugStringBuilder.appendNode(indent, builder, iterator.next());
            hasChildes = true;
        }
        String endIndent = XMLDebugStringBuilder.subIndent(indent);
        if (hasChildes) {
            builder.append(endIndent);
        }
    }

    private static void appendElement(StringBuilder indent, StringBuilder builder, XMLElement element) {
        if (XMLDebugStringBuilder.limitReached(builder)) {
            return;
        }
        builder.append(XMLDebugStringBuilder.addIndent(indent));
        builder.append('<');
        String name = element.getName(true);
        if (name == null) {
            name = "null";
        }
        builder.append(name);
        Iterator<? extends XMLAttribute> attributes = element.getAttributes();
        while (attributes.hasNext() && !XMLDebugStringBuilder.limitReached(builder)) {
            builder.append(' ');
            builder.append(attributes.next());
        }
        boolean hasChildes = false;
        boolean allText = false;
        for (XMLNode node : element) {
            if (!hasChildes) {
                builder.append('>');
                hasChildes = true;
                allText = true;
            }
            if (allText) {
                allText = node instanceof XMLText;
            }
            if (XMLDebugStringBuilder.limitReached(builder)) break;
            XMLDebugStringBuilder.appendNode(indent, builder, node);
        }
        String endIndent = XMLDebugStringBuilder.subIndent(indent);
        if (!element.isVoidHtml()) {
            if (hasChildes) {
                if (!allText) {
                    builder.append(endIndent);
                }
                builder.append("</");
                builder.append(name);
                builder.append('>');
            } else {
                builder.append("/>");
            }
        } else {
            builder.append('>');
        }
    }

    private static void appendText(StringBuilder builder, XMLText xmlText) {
        int i;
        if (XMLDebugStringBuilder.limitReached(builder)) {
            return;
        }
        String text = xmlText.getText();
        if (text == null) {
            text = "null";
        }
        if ((i = 300 - builder.length()) <= 0) {
            return;
        }
        if (i < text.length()) {
            text = text.substring(0, i) + " ...";
        }
        builder.append(text);
    }

    private static void appendDocDeclaration(StringBuilder builder, XMLDocType declaration) {
        if (XMLDebugStringBuilder.limitReached(builder)) {
            return;
        }
        builder.append("<!DOCTYPE ");
        builder.append(declaration.getName());
        builder.append(">\n");
    }

    private static boolean limitReached(StringBuilder builder) {
        return builder.length() >= 300;
    }

    private static String addIndent(StringBuilder indent) {
        int length = indent.length();
        if (length == 0) {
            return "";
        }
        String str = length > 1 ? indent.toString() : "";
        if (length < 10) {
            indent.append(' ');
        }
        return str;
    }

    private static String subIndent(StringBuilder indent) {
        int length = indent.length();
        if (length == 0) {
            return "";
        }
        if (length > 1) {
            indent.deleteCharAt(length - 1);
        }
        return indent.toString();
    }
}

