/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.XmlReader;
import com.reandroid.xml.base.XmlSerializable;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLDocDeclaration
implements XmlReader,
XmlSerializable {
    private String version;
    private String encoding;
    private Boolean standalone;

    public Object get(String nameOrUri) {
        if ("version".equals(nameOrUri) || XMLUtil.PROPERTY_XMLDECL_VERSION.equals(nameOrUri)) {
            return this.getVersion();
        }
        if ("encoding".equals(nameOrUri)) {
            return this.encoding();
        }
        if ("standalone".equals(nameOrUri) || XMLUtil.PROPERTY_XMLDECL_STANDALONE.equals(nameOrUri)) {
            return this.standalone();
        }
        return null;
    }

    public void set(String nameOrUri, Object value) {
        if ("version".equals(nameOrUri) || XMLUtil.PROPERTY_XMLDECL_VERSION.equals(nameOrUri)) {
            this.version((String)value);
        } else if ("encoding".equals(nameOrUri)) {
            this.encoding((String)value);
        } else if ("standalone".equals(nameOrUri) || XMLUtil.PROPERTY_XMLDECL_STANDALONE.equals(nameOrUri)) {
            this.standalone((Boolean)value);
        }
    }

    public String version() {
        return this.version;
    }

    public void version(String version) {
        this.version = version;
    }

    public String getVersion() {
        String version = this.version();
        if (version == null && this.isValid()) {
            version = "1.0";
        }
        return version;
    }

    public String encoding() {
        return this.encoding;
    }

    public void encoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean standalone() {
        return this.standalone;
    }

    public void standalone(Boolean standalone) {
        this.standalone = standalone;
    }

    public boolean isValid() {
        return this.version() != null || this.encoding() != null || this.standalone() != null;
    }

    public void clear() {
        this.version(null);
        this.encoding(null);
        this.standalone(null);
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        if (this.isValid()) {
            serializer.startDocument(this.encoding(), this.standalone());
        }
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        this.clear();
        if (parser.getEventType() == 0) {
            parser.nextToken();
        }
        this.version((String)XMLUtil.getPropertySafe(parser, XMLUtil.PROPERTY_XMLDECL_VERSION));
        this.encoding(parser.getInputEncoding());
        this.standalone((Boolean)XMLUtil.getPropertySafe(parser, XMLUtil.PROPERTY_XMLDECL_STANDALONE));
    }

    public String toString() {
        Boolean standalone;
        if (!this.isValid()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version='");
        builder.append(this.getVersion());
        builder.append("'");
        String encoding = this.encoding();
        if (encoding != null) {
            builder.append(" encoding='");
            builder.append(encoding);
            builder.append("'");
        }
        if ((standalone = this.standalone()) != null) {
            builder.append(" standalone='");
            builder.append(standalone);
            builder.append("'");
        }
        builder.append(" ?>");
        return builder.toString();
    }
}

