/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLProcessingInstruction
extends XMLNode {
    private String mText;

    public XMLProcessingInstruction(String text) {
        this.mText = text;
    }

    public XMLProcessingInstruction() {
        this(null);
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mText = text;
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        XMLUtil.expectEvent(parser, 8);
        this.setText(parser.getText());
        parser.nextToken();
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        String text = this.getText();
        if (text != null) {
            serializer.processingInstruction(text);
        }
    }

    @Override
    void write(Appendable writer, boolean xml, boolean escapeXmlText) throws IOException {
        String text = this.getText();
        if (text != null) {
            writer.append("<?");
            writer.append(text);
            writer.append("?>");
        }
    }

    @Override
    public String toString() {
        return "<?" + this.getText() + "?>";
    }
}

