/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Text;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLText
extends XMLNode
implements Text {
    private String text;

    public XMLText(String text) {
        this.text = text;
    }

    public XMLText() {
        this(null);
    }

    @Override
    public XMLNodeTree getParentNode() {
        return (XMLNodeTree)super.getParentNode();
    }

    @Override
    public String getText() {
        return this.getText(false);
    }

    public String getText(boolean escapeXmlChars) {
        if (escapeXmlChars) {
            return XMLUtil.escapeXmlChars(this.text);
        }
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public void appendText(char ch) {
        if (ch == '\u0000') {
            return;
        }
        this.appendText(String.valueOf(ch));
    }

    public void appendText(String text) {
        if (text == null) {
            return;
        }
        if (this.text == null || this.text.length() == 0) {
            this.text = text;
            return;
        }
        this.text = this.text + text;
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.text(this.getText());
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        if (!XMLText.isTextEvent(event)) {
            throw new XmlPullParserException("Not TEXT event: " + XMLUtil.toEventName(event));
        }
        while (XMLText.isTextEvent(event)) {
            this.appendText(parser.getText());
            event = parser.nextToken();
        }
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        String text = this.getText(escapeXmlText);
        if (text != null) {
            appendable.append(text);
        }
    }

    public boolean isIndent() {
        String text = this.getText();
        return XMLText.isEmptyOrNewlineBlank(text);
    }

    public boolean isBlank() {
        return StringsUtil.isBlank(this.getText());
    }

    @Override
    public String toString() {
        return this.getText();
    }

    static boolean isTextEvent(int event) {
        return event == 4 || event == 6 || event == 7;
    }

    private static boolean isEmptyOrNewlineBlank(String text) {
        if (text == null) {
            return true;
        }
        if (text.length() == 0) {
            return false;
        }
        if (text.indexOf(10) < 0) {
            return false;
        }
        return StringsUtil.isBlank(text);
    }
}

