/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.analysis.reflection.ReflectionConstructor;
import org.jf.dexlib2.analysis.reflection.ReflectionField;
import org.jf.dexlib2.analysis.reflection.ReflectionMethod;
import org.jf.dexlib2.analysis.reflection.util.ReflectionUtils;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.util.collection.CombiningIterator;
import org.jf.util.collection.EmptySet;
import org.jf.util.collection.Iterables;
import org.jf.util.collection.ListUtil;

public class ReflectionClassDef
extends BaseTypeReference
implements ClassDef {
    private final Class cls;
    private static final int DIRECT_MODIFIERS = 10;

    public ReflectionClassDef(Class cls) {
        this.cls = cls;
    }

    @Override
    public int getAccessFlags() {
        return this.cls.getModifiers();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        if (Modifier.isInterface(this.cls.getModifiers())) {
            return "Ljava/lang/Object;";
        }
        Class superClass = this.cls.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return ReflectionUtils.javaToDexName(superClass.getName());
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return ListUtil.copyOf(Iterables.transform(Iterables.forArray(this.cls.getInterfaces()), new Function<Class, String>(){

            @Override
            @Nullable
            public String apply(@Nullable Class input) {
                if (input == null) {
                    return null;
                }
                return ReflectionUtils.javaToDexName(input.getName());
            }
        }));
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return null;
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return EmptySet.of();
    }

    @Override
    @Nonnull
    public Iterable<? extends org.jf.dexlib2.iface.Field> getStaticFields() {
        return new Iterable<org.jf.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                Iterator<Field> staticFields = Iterables.filter(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredFields()), new Predicate<Field>(){

                    @Override
                    public boolean test(@Nullable Field input) {
                        return input != null && Modifier.isStatic(input.getModifiers());
                    }
                });
                return Iterables.transform(staticFields, new Function<Field, org.jf.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public org.jf.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
            }
        };
    }

    @Override
    @Nonnull
    public Iterable<? extends org.jf.dexlib2.iface.Field> getInstanceFields() {
        return new Iterable<org.jf.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                Iterator<Field> staticFields = Iterables.filter(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredFields()), new Predicate<Field>(){

                    @Override
                    public boolean test(@Nullable Field input) {
                        return input != null && !Modifier.isStatic(input.getModifiers());
                    }
                });
                return Iterables.transform(staticFields, new Function<Field, org.jf.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public org.jf.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
            }
        };
    }

    @Nonnull
    public Set<? extends org.jf.dexlib2.iface.Field> getFields() {
        return new AbstractSet<org.jf.dexlib2.iface.Field>(){

            @Override
            @Nonnull
            public Iterator<org.jf.dexlib2.iface.Field> iterator() {
                return Iterables.transform(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredFields()), new Function<Field, org.jf.dexlib2.iface.Field>(){

                    @Override
                    @Nullable
                    public org.jf.dexlib2.iface.Field apply(@Nullable Field input) {
                        return new ReflectionField(input);
                    }
                });
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredFields().length;
            }
        };
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getDirectMethods() {
        return new Iterable<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                Iterator<Method> constructorIterator = Iterables.transform(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredConstructors()), new Function<Constructor, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                Iterator<java.lang.reflect.Method> directMethods = Iterables.filter(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredMethods()), new Predicate<java.lang.reflect.Method>(){

                    @Override
                    public boolean test(@Nullable java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) != 0;
                    }
                });
                Iterator<Method> methodIterator = Iterables.transform(directMethods, new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                return new CombiningIterator<Method>(constructorIterator, methodIterator);
            }
        };
    }

    @Override
    @Nonnull
    public Iterable<? extends Method> getVirtualMethods() {
        return new Iterable<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                Iterator<java.lang.reflect.Method> directMethods = Iterables.filter(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredMethods()), new Predicate<java.lang.reflect.Method>(){

                    @Override
                    public boolean test(@Nullable java.lang.reflect.Method input) {
                        return input != null && (input.getModifiers() & 0xA) == 0;
                    }
                });
                return Iterables.transform(directMethods, new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
            }
        };
    }

    @Nonnull
    public Set<? extends Method> getMethods() {
        return new AbstractSet<Method>(){

            @Override
            @Nonnull
            public Iterator<Method> iterator() {
                Iterator<Method> constructorIterator = Iterables.transform(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredConstructors()), new Function<Constructor, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable Constructor input) {
                        return new ReflectionConstructor(input);
                    }
                });
                Iterator<Method> methodIterator = Iterables.transform(Iterables.forArray(ReflectionClassDef.this.cls.getDeclaredMethods()), new Function<java.lang.reflect.Method, Method>(){

                    @Override
                    @Nullable
                    public Method apply(@Nullable java.lang.reflect.Method input) {
                        return new ReflectionMethod(input);
                    }
                });
                return new CombiningIterator<Method>(constructorIterator, methodIterator);
            }

            @Override
            public int size() {
                return ReflectionClassDef.this.cls.getDeclaredMethods().length + ReflectionClassDef.this.cls.getDeclaredConstructors().length;
            }
        };
    }

    @Override
    @Nonnull
    public String getType() {
        return ReflectionUtils.javaToDexName(this.cls.getName());
    }
}

