/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.BaseAnnotation;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import org.jf.util.ImmutableConverter;
import org.jf.util.ImmutableUtils;

public class ImmutableAnnotation
extends BaseAnnotation {
    protected final int visibility;
    @Nonnull
    protected final String type;
    @Nonnull
    protected final Set<? extends ImmutableAnnotationElement> elements;
    private static final ImmutableConverter<ImmutableAnnotation, Annotation> CONVERTER = new ImmutableConverter<ImmutableAnnotation, Annotation>(){

        @Override
        protected boolean isImmutable(@Nonnull Annotation item) {
            return item instanceof ImmutableAnnotation;
        }

        @Override
        @Nonnull
        protected ImmutableAnnotation makeImmutable(@Nonnull Annotation item) {
            return ImmutableAnnotation.of(item);
        }
    };

    public ImmutableAnnotation(int visibility, @Nonnull String type, @Nullable Collection<? extends AnnotationElement> elements) {
        this.visibility = visibility;
        this.type = type;
        this.elements = ImmutableAnnotationElement.immutableSetOf(elements);
    }

    public ImmutableAnnotation(int visibility, @Nonnull String type, @Nullable Set<? extends ImmutableAnnotationElement> elements) {
        this.visibility = visibility;
        this.type = type;
        this.elements = ImmutableUtils.nullToEmptySet(elements);
    }

    public static ImmutableAnnotation of(Annotation annotation) {
        if (annotation instanceof ImmutableAnnotation) {
            return (ImmutableAnnotation)annotation;
        }
        return new ImmutableAnnotation(annotation.getVisibility(), annotation.getType(), (Collection<? extends AnnotationElement>)annotation.getElements());
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public Set<? extends ImmutableAnnotationElement> getElements() {
        return this.elements;
    }

    @Nonnull
    public static Set<ImmutableAnnotation> immutableSetOf(@Nullable Iterable<? extends Annotation> list) {
        return CONVERTER.toSet(list);
    }
}

