/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.writer.AnnotationSetSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.util.collection.ArraySet;
import org.jf.util.collection.Iterables;

class BuilderAnnotationSetPool
extends BaseBuilderPool
implements AnnotationSetSection<BuilderAnnotation, BuilderAnnotationSet> {
    @Nonnull
    private final ConcurrentMap<Set<? extends Annotation>, BuilderAnnotationSet> internedItems = new ConcurrentHashMap<Set<? extends Annotation>, BuilderAnnotationSet>();

    public BuilderAnnotationSetPool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    @Nonnull
    public BuilderAnnotationSet internAnnotationSet(@Nullable Set<? extends Annotation> annotations) {
        if (annotations == null) {
            return BuilderAnnotationSet.EMPTY;
        }
        BuilderAnnotationSet ret = (BuilderAnnotationSet)this.internedItems.get(annotations);
        if (ret != null) {
            return ret;
        }
        BuilderAnnotationSet annotationSet = new BuilderAnnotationSet(ArraySet.copyOf(Iterables.transform(annotations.iterator(), new Function<Annotation, BuilderAnnotation>(){

            @Override
            @Nullable
            public BuilderAnnotation apply(Annotation input) {
                return ((BuilderAnnotationPool)BuilderAnnotationSetPool.this.dexBuilder.annotationSection).internAnnotation(input);
            }
        })));
        ret = this.internedItems.putIfAbsent(annotationSet, annotationSet);
        return ret == null ? annotationSet : ret;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderAnnotation> getAnnotations(@Nonnull BuilderAnnotationSet key) {
        return key.annotations;
    }

    @Override
    public int getNullableItemOffset(@Nullable BuilderAnnotationSet key) {
        return key == null ? 0 : key.offset;
    }

    @Override
    public int getItemOffset(@Nonnull BuilderAnnotationSet key) {
        return key.offset;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderAnnotationSet, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderAnnotationSet>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderAnnotationSet key) {
                return key.offset;
            }

            @Override
            protected int setValue(@Nonnull BuilderAnnotationSet key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

