/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jf.util.collection.EmptySet;

public class ArraySet<T>
implements Set<T>,
Comparator<T> {
    private final ArrayList<T> items;
    private Comparator<? super T> comparator;
    private int mHashCode;
    private int mHashCodeStamp = -1;

    public ArraySet() {
        this.items = new ArrayList();
    }

    public ArraySet(int initialCapacity) {
        this.items = new ArrayList(initialCapacity);
    }

    public ArraySet(Collection<? extends T> collection) {
        this.items = new ArrayList(collection.size());
        this.addAll((Collection<? extends T>)collection);
    }

    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super T> comparator) {
        this.comparator = comparator;
        if (comparator != null) {
            this.sort(comparator);
        }
    }

    public void trimToSize() {
        this.items.trimToSize();
    }

    @Override
    public boolean addAll(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return false;
        }
        if (iterable instanceof Collection) {
            return this.addAll((Collection)iterable);
        }
        return this.addAll(iterable.iterator());
    }

    @Override
    public boolean addAll(Iterator<? extends T> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return false;
        }
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        this.trimToSize();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(T ... elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        ArrayList<T> arrayList = this.items;
        synchronized (arrayList) {
            ArrayList<T> items = this.items;
            items.ensureCapacity(items.size() + elements.length);
            boolean result = false;
            for (T item : elements) {
                if (item == null || items.contains(item)) continue;
                items.add(item);
                result = true;
            }
            return result;
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.items.contains(obj);
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] t1s) {
        return this.items.toArray(t1s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T item) {
        T t = item;
        synchronized (t) {
            if (item == null) {
                return false;
            }
            if (this.items.contains(item)) {
                return !this.items.contains(item);
            }
            this.items.add(item);
            return true;
        }
    }

    private T getByHash(int hash) {
        for (T item : this.items) {
            if (item.hashCode() != hash) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object obj) {
        if (obj == null) {
            return false;
        }
        ArrayList<T> arrayList = this.items;
        synchronized (arrayList) {
            return this.items.remove(obj);
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.items.containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection == null || collection.size() == 0 || collection == this) {
            return false;
        }
        ArrayList<T> arrayList = this.items;
        synchronized (arrayList) {
            ArrayList<T> items = this.items;
            items.ensureCapacity(items.size() + collection.size());
            boolean result = false;
            for (T item : collection) {
                if (item == null || items.contains(item)) continue;
                items.add(item);
                result = true;
            }
            if (result) {
                this.trimToSize();
            }
            return result;
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.items.retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean result = this.items.removeAll(collection);
        this.trimToSize();
        return result;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.trimToSize();
    }

    @Override
    public int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 instanceof Comparable && t2 instanceof Comparable) {
            Comparable comparable1 = (Comparable)t1;
            return comparable1.compareTo(t2);
        }
        return 0;
    }

    public ArraySet<T> sort() {
        return this.sort(this);
    }

    public ArraySet<T> sort(Comparator<? super T> comparator) {
        this.items.sort(comparator);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set set = (Set)obj;
        int size = this.size();
        if (set.size() != size) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        if (ArraySet.getHashCode(set) != this.hashCode()) {
            return false;
        }
        Iterator<T> iterator1 = this.iterator();
        Iterator iterator2 = set.iterator();
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (iterator1.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.mHashCodeStamp != this.items.size()) {
            this.mHashCode = ArraySet.hashCode(this);
            this.mHashCodeStamp = this.items.size();
        }
        return this.mHashCode;
    }

    private static int getHashCode(Set<?> set) {
        if (set instanceof ArraySet) {
            return set.hashCode();
        }
        return ArraySet.hashCode(set);
    }

    public static int hashCode(Set<?> set) {
        int[] hashArray = ArraySet.sortedHashCode(set);
        int hashCode = 1;
        for (int hash : hashArray) {
            hashCode = hashCode * 31 + hash;
        }
        return hashCode;
    }

    private static int[] sortedHashCode(Set<?> set) {
        int[] results = new int[set.size()];
        int index = 0;
        for (Object obj : set) {
            if (obj != null) {
                results[index] = obj.hashCode();
            }
            ++index;
        }
        Arrays.sort(results);
        return results;
    }

    public static <E> ArraySet<E> sortedCopy(Iterator<? extends E> elements) {
        ArraySet<E> arraySet = ArraySet.copyOf(elements);
        arraySet.sort();
        return arraySet;
    }

    public static <E> ArraySet<E> copyOf(Iterable<? extends E> elements) {
        if (elements == null) {
            return EmptySet.of();
        }
        ArraySet<? extends E> arraySet = new ArraySet<E>();
        arraySet.addAll(elements);
        return arraySet;
    }

    public static <E> ArraySet<E> copyOf(Collection<? extends E> elements) {
        if (elements == null) {
            return EmptySet.of();
        }
        ArraySet<? extends E> arraySet = new ArraySet<E>();
        arraySet.addAll(elements);
        return arraySet;
    }

    public static <E> ArraySet<E> copyOf(Iterator<? extends E> elements) {
        if (!elements.hasNext()) {
            return EmptySet.of();
        }
        ArraySet<E> arraySet = new ArraySet<E>();
        arraySet.addAll(elements);
        return arraySet;
    }

    public static <E> ArraySet<E> copyOfElements(E ... elements) {
        if (elements == null || elements.length == 0) {
            return EmptySet.of();
        }
        ArraySet<E> arraySet = new ArraySet<E>();
        arraySet.addAll(elements);
        return arraySet;
    }

    public static <E> ArraySet<E> of() {
        return EmptySet.of();
    }

    public static <E> ArraySet<E> of(E ... elements) {
        if (elements == null || elements.length == 0) {
            return EmptySet.of();
        }
        ArraySet<E> arraySet = new ArraySet<E>();
        arraySet.addAll(elements);
        return arraySet;
    }
}

